/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.sf.robocode.battle.BattleProperties;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.NewBattleRulesTab;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.dialog.WizardTabbedPane;
import net.sf.robocode.ui.util.ShortcutUtil;

public class NewBattleDialog
extends JDialog
implements WizardListener {
    private static final int MAX_ROBOTS = 256;
    private static final int MIN_ROBOTS = 1;
    private final EventHandler eventHandler = new EventHandler();
    private ISettingsManager settingsManager;
    private BattleProperties battleProperties;
    private WizardTabbedPane tabbedPane;
    private NewBattleRulesTab battleFieldTab;
    private WizardController wizardController;
    private RobotSelectionPanel robotSelectionPanel;
    private final IBattleManager battleManager;

    public NewBattleDialog(IWindowManager windowManager, IBattleManager battleManager) {
        super((Frame)windowManager.getRobocodeFrame(), true);
        this.battleManager = battleManager;
    }

    public void setup(ISettingsManager settingsManager, BattleProperties battleProperties) {
        this.settingsManager = settingsManager;
        this.battleProperties = battleProperties;
        this.robotSelectionPanel = null;
        this.setTitle("New Battle");
        this.setPreferredSize(new Dimension(850, 650));
        this.setDefaultCloseOperation(2);
        this.addCancelByEscapeKey();
        this.add(this.createNewBattleDialogPanel());
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    @Override
    public void finishButtonActionPerformed() {
        if (this.robotSelectionPanel.getSelectedRobotsCount() > 24 && JOptionPane.showConfirmDialog(this, "Warning:  The battle you are about to start (" + this.robotSelectionPanel.getSelectedRobotsCount() + " robots)  is very large and will consume a lot of CPU and memory.  Do you wish to proceed?", "Large Battle Warning", 0, 2) == 1) {
            return;
        }
        if (this.robotSelectionPanel.getSelectedRobotsCount() == 1 && JOptionPane.showConfirmDialog(this, "You have only selected one robot.  For normal battles you should select at least 2.\nDo you wish to proceed anyway?", "Just one robot?", 0, 3) == 1) {
            return;
        }
        this.dispose();
        this.battleManager.startNewBattle(this.battleProperties, false, false);
    }

    private NewBattleRulesTab getBattleFieldTab() {
        if (this.battleFieldTab == null) {
            this.battleFieldTab = new NewBattleRulesTab();
            this.battleFieldTab.setup(this.settingsManager, this.battleProperties);
        }
        return this.battleFieldTab;
    }

    private JPanel createNewBattleDialogPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getWizardController(), "South");
        panel.add((Component)this.getTabbedPane(), "Center");
        panel.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
        return panel;
    }

    public List<IRobotSpecItem> getSelectedRobots() {
        return this.getRobotSelectionPanel().getSelectedRobots();
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewBattleDialog.this.cancelButtonActionPerformed();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private WizardController getWizardController() {
        if (this.wizardController == null) {
            this.wizardController = this.getTabbedPane().getWizardController();
            this.wizardController.setFinishButtonTextAndMnemonic("Start Battle", 'S', 0);
            this.wizardController.setFocusOnEnabled(true);
        }
        return this.wizardController;
    }

    private RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            this.robotSelectionPanel.addAncestorListener(this.eventHandler);
            boolean ignoreTeamRobots = false;
            String selectedRobots = this.battleProperties == null ? "" : this.battleProperties.getSelectedRobots();
            this.robotSelectionPanel.setup(1, 256, true, "Select robots for the battle", false, false, false, false, false, false, selectedRobots);
        }
        return this.robotSelectionPanel;
    }

    private WizardTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new WizardTabbedPane(this);
            this.tabbedPane.insertTab("Robots", null, this.getRobotSelectionPanel(), null, 0);
            this.tabbedPane.setMnemonicAt(0, 82);
            this.tabbedPane.setDisplayedMnemonicIndexAt(0, 0);
            this.tabbedPane.insertTab("Rules", null, this.getBattleFieldTab(), null, 1);
            this.tabbedPane.setMnemonicAt(1, 85);
            this.tabbedPane.setDisplayedMnemonicIndexAt(1, 1);
        }
        return this.tabbedPane;
    }

    private class EventHandler
    implements AncestorListener,
    ActionListener {
        private EventHandler() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            NewBattleDialog.this.battleProperties.setSelectedRobots(NewBattleDialog.this.getRobotSelectionPanel().getSelectedRobotsAsString());
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("Refresh")) {
                NewBattleDialog.this.getRobotSelectionPanel().refreshRobotList(true);
            }
        }
    }
}

