/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.host.io.RobotFileOutputStream;
import net.sf.robocode.host.io.RobotFileSystemManager;
import robocode.exception.RobotException;

public class ThreadManager
implements IThreadManager {
    private final PrintStream syserr = System.err;
    private final List<Thread> safeThreads = new CopyOnWriteArrayList<Thread>();
    private final List<ThreadGroup> safeThreadGroups = new CopyOnWriteArrayList<ThreadGroup>();
    private final List<ThreadGroup> groups = new CopyOnWriteArrayList<ThreadGroup>();
    private final List<Thread> outputStreamThreads = new CopyOnWriteArrayList<Thread>();
    private final List<IHostedThread> robots = new CopyOnWriteArrayList<IHostedThread>();
    private Thread robotLoaderThread;
    private IHostedThread loadingRobot;

    @Override
    public void addSafeThread(Thread safeThread) {
        this.safeThreads.add(safeThread);
    }

    @Override
    public void removeSafeThread(Thread safeThread) {
        this.safeThreads.remove(safeThread);
    }

    @Override
    public void addSafeThreadGroup(ThreadGroup safeThreadGroup) {
        this.safeThreadGroups.add(safeThreadGroup);
    }

    @Override
    public void addThreadGroup(ThreadGroup g, IHostedThread robotProxy) {
        if (!this.groups.contains(g)) {
            this.groups.add(g);
            this.robots.add(robotProxy);
        }
    }

    public synchronized IHostedThread getLoadingRobot() {
        return this.loadingRobot;
    }

    @Override
    public synchronized IHostedThread getLoadingRobotProxy(Thread t) {
        if (t != null && this.robotLoaderThread != null && (t.equals(this.robotLoaderThread) || t.getThreadGroup() != null && t.getThreadGroup().equals(this.robotLoaderThread.getThreadGroup()))) {
            return this.loadingRobot;
        }
        return null;
    }

    @Override
    public synchronized IHostedThread getLoadedOrLoadingRobotProxy(Thread t) {
        IHostedThread robotProxy = this.getRobotProxy(t);
        if (robotProxy == null) {
            robotProxy = this.getLoadingRobotProxy(t);
        }
        return robotProxy;
    }

    @Override
    public IHostedThread getRobotProxy(Thread t) {
        ThreadGroup g = t.getThreadGroup();
        if (g == null) {
            return null;
        }
        int index = this.groups.indexOf(g);
        if (index == -1) {
            return null;
        }
        return this.robots.get(index);
    }

    @Override
    public void reset() {
        this.groups.clear();
        this.robots.clear();
    }

    @Override
    public synchronized void setLoadingRobot(IHostedThread newLoadingRobotProxy) {
        if (newLoadingRobotProxy == null) {
            this.robotLoaderThread = null;
            this.loadingRobot = null;
        } else {
            this.robotLoaderThread = Thread.currentThread();
            this.loadingRobot = newLoadingRobotProxy;
        }
    }

    public boolean isSafeThread() {
        return this.isSafeThread(Thread.currentThread());
    }

    public FileOutputStream createRobotFileStream(String fileName, boolean append) throws IOException {
        long len;
        final Thread c = Thread.currentThread();
        IHostedThread robotProxy = this.getRobotProxy(c);
        if (robotProxy == null) {
            this.syserr.println("RobotProxy is null");
            return null;
        }
        if (!robotProxy.getStatics().isAdvancedRobot()) {
            throw new RobotException("Only advanced robots could create files");
        }
        final File dir = robotProxy.getRobotFileSystemManager().getWritableDirectory();
        if (!dir.exists()) {
            robotProxy.println("SYSTEM: Creating a data directory for you.");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ThreadManager.this.outputStreamThreads.add(c);
                    if (!dir.exists() && !dir.mkdirs()) {
                        ThreadManager.this.syserr.println("Can't create dir " + dir);
                    }
                    return null;
                }
            });
        }
        RobotFileSystemManager fileSystemManager = robotProxy.getRobotFileSystemManager();
        File f = new File(fileName);
        if (f.exists()) {
            len = f.length();
        } else {
            fileSystemManager.checkQuota();
            len = 0L;
        }
        if (!append) {
            fileSystemManager.adjustQuota(-len);
        }
        this.outputStreamThreads.add(c);
        return new RobotFileOutputStream(fileName, append, fileSystemManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRobotFileStream() {
        Thread c = Thread.currentThread();
        List<Thread> list = this.outputStreamThreads;
        synchronized (list) {
            if (this.outputStreamThreads.contains(c)) {
                this.outputStreamThreads.remove(c);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSafeThread(Thread c) {
        try {
            if (this.safeThreads.contains(c)) {
                return true;
            }
            for (ThreadGroup tg : this.safeThreadGroups) {
                if (c.getThreadGroup() != tg) continue;
                this.safeThreads.add(c);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.syserr.println("Exception checking safe thread: ");
            e.printStackTrace(this.syserr);
            return false;
        }
    }

    @Override
    public PrintStream getRobotOutputStream() {
        Thread c = Thread.currentThread();
        if (this.isSafeThread(c)) {
            return null;
        }
        IHostedThread robotProxy = this.getLoadedOrLoadingRobotProxy(c);
        return robotProxy != null ? robotProxy.getOut() : null;
    }
}

