/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.configuration;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.sf.qualitytest.blueprint.CycleHandlingStrategy;
import net.sf.qualitytest.blueprint.configuration.DefaultBlueprintConfiguration;
import net.sf.qualitytest.blueprint.configuration.ImmutableBlueprintConfiguration;
import net.sf.qualitytest.blueprint.configuration.StrategyPair;
import net.sf.qualitytest.blueprint.strategy.creation.BlueprintCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.BlueprintStringCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomBooleanValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomByteValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomCharValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomDoubleValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomEnumCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomFloatValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomIntValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomLongValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomShortValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.ValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.InstanceOfTypeMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.SetterMethodMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.TypeMatchingStrategy;

public final class RandomBlueprintConfiguration
extends ImmutableBlueprintConfiguration {
    private static final ValueCreationStrategy<Long> LONG_DEFAULT = new RandomLongValueCreationStrategy();
    private static final ValueCreationStrategy<Integer> INTEGER_DEFAULT = new RandomIntValueCreationStrategy();
    private static final ValueCreationStrategy<Boolean> BOOLEAN_DEFAULT = new RandomBooleanValueCreationStrategy();
    private static final ValueCreationStrategy<Character> CHARACTER_DEFAULT = new RandomCharValueCreationStrategy();
    private static final ValueCreationStrategy<Short> SHORT_DEFAULT = new RandomShortValueCreationStrategy();
    private static final ValueCreationStrategy<Byte> BYTE_DEFAULT = new RandomByteValueCreationStrategy();
    private static final ValueCreationStrategy<Float> FLOAT_DEFAULT = new RandomFloatValueCreationStrategy();
    private static final ValueCreationStrategy<Double> DOUBLE_DEFAULT = new RandomDoubleValueCreationStrategy();

    public static void addRandomEnumStrategy(List<StrategyPair> list) {
        list.add(new StrategyPair(new InstanceOfTypeMatchingStrategy(Enum.class), new RandomEnumCreationStrategy()));
    }

    private static List<StrategyPair> createDefaultAttributeMapping() {
        ArrayList<StrategyPair> list = new ArrayList<StrategyPair>();
        list.add(new StrategyPair(new TypeMatchingStrategy(String.class), new BlueprintStringCreationStrategy()));
        list.add(new StrategyPair(new TypeMatchingStrategy(Long.class), LONG_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Long.TYPE), LONG_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Integer.class), INTEGER_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Integer.TYPE), INTEGER_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Boolean.class), BOOLEAN_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Boolean.TYPE), BOOLEAN_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Character.class), CHARACTER_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Character.TYPE), CHARACTER_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Short.class), SHORT_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Short.TYPE), SHORT_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Byte.class), BYTE_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Byte.TYPE), BYTE_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Float.class), FLOAT_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Float.TYPE), FLOAT_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Double.class), DOUBLE_DEFAULT));
        list.add(new StrategyPair(new TypeMatchingStrategy(Double.TYPE), DOUBLE_DEFAULT));
        RandomBlueprintConfiguration.addRandomEnumStrategy(list);
        DefaultBlueprintConfiguration.addDefaultArrayStrategy(list);
        DefaultBlueprintConfiguration.addDefaultCollections(list);
        list.add(new StrategyPair(new SetterMethodMatchingStrategy(), new BlueprintCreationStrategy()));
        return list;
    }

    public RandomBlueprintConfiguration() {
        super(RandomBlueprintConfiguration.createDefaultAttributeMapping(), (List<CycleHandlingStrategy<?>>)ImmutableList.of(), false);
    }
}

