/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNegativeArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.blueprint.Blueprint;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintSession;

public final class CollectionBlueprint {
    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNegativeArgumentException.class})
    public static <T extends Collection<E>, E> T addMany(@Nonnull T collection, @Nonnull Class<E> clazz, @Nonnegative int numberOfItems) {
        return CollectionBlueprint.addMany(collection, clazz, numberOfItems, Blueprint.def());
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNegativeArgumentException.class})
    public static <T extends Collection<E>, E> T addMany(@Nonnull T collection, @Nonnull Class<E> clazz, @Nonnegative int numberOfItems, @Nonnull BlueprintConfiguration config) {
        Check.notNull(collection, (String)"collection");
        Check.notNull(clazz, (String)"clazz");
        Check.notNegative((int)numberOfItems, (String)"numberOfItems");
        Check.notNull((Object)config, (String)"config");
        for (int cnt = numberOfItems; cnt > 0; --cnt) {
            collection.add(Blueprint.construct(clazz, config, new BlueprintSession()));
        }
        return collection;
    }

    private CollectionBlueprint() {
    }
}

