/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import javax.annotation.Nonnull;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.SafeInvoke;
import net.sf.qualitytest.exception.BlueprintException;

public abstract class BlueprintExceptionRunnable<T>
implements SafeInvoke.ExceptionRunnable<T> {
    private final BlueprintSession session;

    @ArgumentsChecked
    public BlueprintExceptionRunnable(@Nonnull BlueprintSession session, @Nonnull String lastAction) {
        this.session = (BlueprintSession)Check.notNull((Object)session, (String)"session");
        session.setLastAction((String)Check.notNull((Object)lastAction, (String)"lastAction"));
    }

    @Override
    public T run() throws Exception {
        try {
            return this.runInternal();
        }
        catch (Exception e) {
            BlueprintException b = new BlueprintException(e);
            b.setSession(this.session);
            throw b;
        }
    }

    protected abstract T runInternal() throws Exception;
}

