/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.ModifierBits;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintExceptionRunnable;
import net.sf.qualitytest.blueprint.BlueprintInvocationHandler;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;
import net.sf.qualitytest.blueprint.SafeInvoke;
import net.sf.qualitytest.blueprint.configuration.DefaultBlueprintConfiguration;
import net.sf.qualitytest.blueprint.configuration.RandomBlueprintConfiguration;
import net.sf.qualitytest.exception.BlueprintException;
import net.sf.qualitytest.exception.NoPublicConstructorException;

public final class Blueprint {
    private static final BlueprintConfiguration DEFAULT_CONFIG = new DefaultBlueprintConfiguration();

    @Throws(value={IllegalNullArgumentException.class})
    private static <T> T bean(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config, @Nonnull BlueprintSession session) {
        Check.notNull(clazz, (String)"clazz");
        Check.notNull((Object)config, (String)"config");
        Check.notNull((Object)session, (String)"sesion");
        T obj = Blueprint.safeNewInstance(session, clazz);
        Blueprint.blueprintPublicMethods(obj, clazz, config, session);
        Blueprint.blueprintPublicAttributes(obj, clazz, config, session);
        return obj;
    }

    private static <T> void blueprintAllAttributes(T obj, Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        for (Field f : clazz.getDeclaredFields()) {
            boolean isStatic = ModifierBits.isModifierBitSet(f.getModifiers(), 8);
            if (isStatic) continue;
            Blueprint.blueprintField(obj, f, config, session);
        }
    }

    private static void blueprintField(final Object that, final Field field, BlueprintConfiguration config, BlueprintSession session) {
        CreationStrategy<?> creator = config.findCreationStrategyForField(field);
        if (creator == null) {
            creator = config.findCreationStrategyForType(field.getType());
        }
        final Object value = Blueprint.blueprintObject(field.getType(), config, creator, session);
        String action = MessageFormat.format("Setting field {0} to {1}.", field.getName(), value);
        SafeInvoke.invoke(new BlueprintExceptionRunnable<Object>(session, action){

            @Override
            public Object runInternal() throws Exception {
                field.setAccessible(true);
                field.set(that, value);
                return null;
            }
        }, BlueprintException.class);
    }

    private static void blueprintMethod(final Object that, final Method m, BlueprintConfiguration config, BlueprintSession session) {
        CreationStrategy<?> creator = config.findCreationStrategyForMethod(m);
        if (creator != null) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            final Object[] values = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                values[i] = creator.createValue(parameterTypes[i], config, session);
            }
            String action = MessageFormat.format("Invoking method {0} with arguments {1}.", m.getName(), values);
            SafeInvoke.invoke(new BlueprintExceptionRunnable<Object>(session, action){

                @Override
                public Object runInternal() throws Exception {
                    m.setAccessible(true);
                    m.invoke(that, values);
                    return null;
                }
            }, BlueprintException.class);
        }
    }

    @Nullable
    private static <T> T blueprintObject(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config, @Nullable CreationStrategy<?> creator, @Nonnull BlueprintSession session) {
        boolean cycle = session.push(clazz);
        Object ret = cycle ? config.handleCycle(session, clazz) : (creator != null ? creator.createValue(clazz, config, session) : (clazz.isInterface() ? Blueprint.proxy(clazz, config, session) : (Blueprint.hasPublicDefaultConstructor(clazz) ? Blueprint.bean(clazz, config, session) : Blueprint.immutable(clazz, config, session))));
        session.pop();
        return ret;
    }

    private static <T> void blueprintPublicAttributes(T obj, Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        if (!config.isWithPublicAttributes()) {
            return;
        }
        for (Field f : clazz.getFields()) {
            boolean isStatic = ModifierBits.isModifierBitSet(f.getModifiers(), 8);
            boolean isFinal = ModifierBits.isModifierBitSet(f.getModifiers(), 16);
            if (isStatic || isFinal) continue;
            Blueprint.blueprintField(obj, f, config, session);
        }
    }

    private static <T> void blueprintPublicMethods(T obj, Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        for (Method m : clazz.getMethods()) {
            if (!Blueprint.isRelevant(m)) continue;
            Blueprint.blueprintMethod(obj, m, config, session);
        }
    }

    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T construct(@Nonnull Class<T> clazz) {
        Check.notNull(clazz, (String)"clazz");
        return Blueprint.construct(clazz, DEFAULT_CONFIG, new BlueprintSession());
    }

    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T construct(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config) {
        Check.notNull(clazz, (String)"clazz");
        Check.notNull((Object)config, (String)"config");
        return Blueprint.construct(clazz, config, new BlueprintSession());
    }

    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T construct(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config, @Nonnull BlueprintSession session) {
        Check.notNull(clazz, (String)"clazz");
        Check.notNull((Object)config, (String)"config");
        Check.notNull((Object)session, (String)"session");
        CreationStrategy<?> creator = config.findCreationStrategyForType(clazz);
        return Blueprint.blueprintObject(clazz, config, creator, session);
    }

    public static BlueprintConfiguration def() {
        return new DefaultBlueprintConfiguration();
    }

    private static <T> Constructor<?> findFirstPublicConstructor(Class<T> clazz) {
        int i$ = 0;
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?>[] arr$ = constructors;
        int len$ = arr$.length;
        if (i$ < len$) {
            Constructor<?> c = arr$[i$];
            return c;
        }
        return null;
    }

    private static boolean hasPublicDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = clazz.getConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static <T> T immutable(Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        Constructor<?> constructor = Blueprint.findFirstPublicConstructor(clazz);
        if (constructor == null) {
            NoPublicConstructorException b = new NoPublicConstructorException(clazz.getSimpleName());
            String action = MessageFormat.format("Finding public constructor in {0}", clazz.getName());
            session.setLastAction(action);
            b.setSession(session);
            throw b;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = Blueprint.construct(parameterTypes[i], config, session);
        }
        T obj = Blueprint.safeNewInstance(session, constructor, parameters);
        Blueprint.blueprintAllAttributes(obj, clazz, config, session);
        return obj;
    }

    protected static boolean isRelevant(Method m) {
        boolean isNotStatic = !ModifierBits.isModifierBitSet(m.getModifiers(), 8);
        boolean isPublic = ModifierBits.isModifierBitSet(m.getModifiers(), 1);
        return isNotStatic && isPublic;
    }

    private static <T> T proxy(Class<T> iface, BlueprintConfiguration config, BlueprintSession session) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new BlueprintInvocationHandler(config, session));
    }

    public static BlueprintConfiguration random() {
        return new RandomBlueprintConfiguration();
    }

    private static <T> T safeNewInstance(BlueprintSession session, final Class<T> clazz) {
        String action = MessageFormat.format("Creating clazz {0} with default constructor.", clazz.getName());
        return SafeInvoke.invoke(new BlueprintExceptionRunnable<T>(session, action){

            @Override
            public T runInternal() throws Exception {
                return clazz.newInstance();
            }
        }, BlueprintException.class);
    }

    private static <T> T safeNewInstance(BlueprintSession session, final Constructor<?> constructor, final Object[] parameters) {
        String action = MessageFormat.format("Creating clazz {0} with constructor {1}.", constructor.getClass().getName(), constructor.toGenericString());
        return SafeInvoke.invoke(new BlueprintExceptionRunnable<T>(session, action){

            @Override
            public T runInternal() throws Exception {
                return constructor.newInstance(parameters);
            }
        }, BlueprintException.class);
    }

    private Blueprint() {
    }
}

