/*******************************************************************************
 * Copyright 2013 André Rouél and Dominik Seichter
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package net.sf.qualitytest.blueprint.strategy.creation;

import net.sf.qualitytest.blueprint.Blueprint;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;

/**
 * This {@code CreationStrategy} constructs the requested object using {@code Blueprint} itself.
 * 
 * @author Dominik Seichter
 * 
 */
public class BlueprintCreationStrategy implements CreationStrategy<Object> {

	@Override
	public Object createValue(final Class<?> expectedClazz, final BlueprintConfiguration config, final BlueprintSession session) {
		return Blueprint.construct(expectedClazz, config, session);
	}

}
