/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.blueprint.Blueprint;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;
import net.sf.qualitytest.blueprint.MatchingStrategy;
import net.sf.qualitytest.blueprint.configuration.StrategyPair;
import net.sf.qualitytest.blueprint.strategy.creation.BlueprintCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.SingleValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.CaseInsensitiveMethodNameMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.TypeMatchingStrategy;

class ImmutableBlueprintConfiguration
implements BlueprintConfiguration {
    private final List<StrategyPair> mapping;
    private final boolean withPublicAttributes;

    public ImmutableBlueprintConfiguration() {
        this.mapping = ImmutableList.of();
        this.withPublicAttributes = false;
    }

    protected ImmutableBlueprintConfiguration(@Nonnull List<StrategyPair> attributeMapping, boolean withPublicAttributes) {
        Check.notNull(attributeMapping, (String)"attributeMapping");
        this.mapping = ImmutableList.copyOf(attributeMapping);
        this.withPublicAttributes = withPublicAttributes;
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public <T> T construct(@Nonnull Class<T> clazz) {
        return Blueprint.construct(clazz, this, new BlueprintSession());
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public CreationStrategy<?> findCreationStrategyForMethod(@Nonnull Method method) {
        Check.notNull((Object)method, (String)"method");
        for (StrategyPair entry : Lists.reverse(this.mapping)) {
            if (!entry.getKey().matchesByMethod(method)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public CreationStrategy<?> findCreationStrategyForType(@Nonnull Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        for (StrategyPair entry : Lists.reverse(this.mapping)) {
            if (!entry.getKey().matchesByType(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean isWithPublicAttributes() {
        return this.withPublicAttributes;
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class})
    public <T> BlueprintConfiguration with(@Nonnull Class<T> type, @Nullable T value) {
        return this.with(new TypeMatchingStrategy(type), new SingleValueCreationStrategy<T>(value));
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class})
    public <T> BlueprintConfiguration with(@Nonnull MatchingStrategy matchingStrategy) {
        return this.with(matchingStrategy, new BlueprintCreationStrategy());
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class})
    public BlueprintConfiguration with(@Nonnull MatchingStrategy matcher, @Nonnull CreationStrategy<?> creator) {
        Check.notNull((Object)matcher, (String)"matcher");
        Check.notNull(creator, (String)"creator");
        ArrayList<StrategyPair> mapping = new ArrayList<StrategyPair>();
        mapping.addAll(this.mapping);
        mapping.add(new StrategyPair(matcher, creator));
        return new ImmutableBlueprintConfiguration(mapping, this.withPublicAttributes);
    }

    @Override
    @Nonnull
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public <T> BlueprintConfiguration with(@Nonnull String name, @Nullable T value) {
        Check.notEmpty((CharSequence)name, (String)"name");
        return this.with(new CaseInsensitiveMethodNameMatchingStrategy(name), new SingleValueCreationStrategy<T>(value));
    }

    @Override
    @Nonnull
    public BlueprintConfiguration withPublicAttributes(boolean withPublicAttributes) {
        return new ImmutableBlueprintConfiguration(this.mapping, withPublicAttributes);
    }
}

