/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.configuration.ImmutableBlueprintConfiguration;
import net.sf.qualitytest.blueprint.configuration.StrategyPair;
import net.sf.qualitytest.blueprint.strategy.creation.BlueprintCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.DefaultArrayCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.DefaultEnumCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.SingleValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.ArrayTypeMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.InterfaceOfTypeMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.SetterMethodMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.TypeMatchingStrategy;

public final class DefaultBlueprintConfiguration
extends ImmutableBlueprintConfiguration {
    private static final String STRING_DEFAULT = "";
    private static final Long LONG_DEFAULT = 0L;
    private static final Integer INTEGER_DEFAULT = 0;
    private static final Boolean BOOLEAN_DEFAULT = Boolean.FALSE;
    private static final Character CHARACTER_DEFAULT = Character.valueOf('\u0000');
    private static final Short SHORT_DEFAULT = 0;
    private static final Byte BYTE_DEFAULT = 0;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);
    private static final Double DOUBLE_DEFAULT = 0.0;

    public static void addDefaultArrayStrategy(List<StrategyPair> list) {
        list.add(new StrategyPair(new ArrayTypeMatchingStrategy(), new DefaultArrayCreationStrategy(7)));
    }

    public static void addDefaultCollections(List<StrategyPair> list) {
        Check.notNull(list, (String)"list");
        list.add(new StrategyPair(new TypeMatchingStrategy(Map.class), new SingleValueCreationStrategy(new HashMap())));
        list.add(new StrategyPair(new TypeMatchingStrategy(Set.class), new SingleValueCreationStrategy(new HashSet())));
        list.add(new StrategyPair(new TypeMatchingStrategy(List.class), new SingleValueCreationStrategy(new ArrayList())));
    }

    public static void addDefaultEnumStrategy(List<StrategyPair> list) {
        list.add(new StrategyPair(new InterfaceOfTypeMatchingStrategy(Enum.class), new DefaultEnumCreationStrategy()));
    }

    private static List<StrategyPair> createDefaultAttributeMapping() {
        ArrayList<StrategyPair> list = new ArrayList<StrategyPair>();
        list.add(DefaultBlueprintConfiguration.createStrategyPair(String.class, STRING_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Long.class, LONG_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Long.TYPE, LONG_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Integer.class, INTEGER_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Integer.TYPE, INTEGER_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Boolean.class, BOOLEAN_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Boolean.TYPE, BOOLEAN_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Character.class, CHARACTER_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Character.TYPE, CHARACTER_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Short.class, SHORT_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Short.TYPE, SHORT_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Byte.class, BYTE_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Byte.TYPE, BYTE_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Float.class, FLOAT_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Float.TYPE, FLOAT_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Double.class, DOUBLE_DEFAULT));
        list.add(DefaultBlueprintConfiguration.createStrategyPair(Double.TYPE, DOUBLE_DEFAULT));
        DefaultBlueprintConfiguration.addDefaultEnumStrategy(list);
        DefaultBlueprintConfiguration.addDefaultArrayStrategy(list);
        DefaultBlueprintConfiguration.addDefaultCollections(list);
        list.add(new StrategyPair(new SetterMethodMatchingStrategy(), new BlueprintCreationStrategy()));
        return list;
    }

    private static <T> StrategyPair createStrategyPair(Class<T> clazz, T defaultValue) {
        return new StrategyPair(new TypeMatchingStrategy(clazz), new SingleValueCreationStrategy<T>(defaultValue));
    }

    public DefaultBlueprintConfiguration() {
        super(DefaultBlueprintConfiguration.createDefaultAttributeMapping(), false);
    }
}

