/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.exception.BlueprintException;

final class SafeInvoke {
    private static RuntimeException createException(Throwable e, Class<? extends RuntimeException> exceptionClass) {
        try {
            return SafeInvoke.createExceptionInternal(e, exceptionClass);
        }
        catch (Exception exception) {
            throw new BlueprintException(exception);
        }
    }

    private static RuntimeException createExceptionInternal(Throwable e, Class<? extends RuntimeException> exceptionClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = exceptionClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0] != Throwable.class) continue;
            return (RuntimeException)c.newInstance(e);
        }
        return exceptionClass.newInstance();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T invoke(@Nonnull ExceptionRunnable<T> runnable, @Nonnull Class<? extends RuntimeException> exceptionClass) {
        Check.notNull(runnable, (String)"runnable");
        Check.notNull(exceptionClass, (String)"exceptionClass");
        try {
            return runnable.run();
        }
        catch (Exception t) {
            RuntimeException e = SafeInvoke.createException(t, exceptionClass);
            throw e;
        }
    }

    private SafeInvoke() {
    }

    public static interface ExceptionRunnable<T> {
        public T run() throws Exception;
    }
}

