/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.exception.BlueprintCycleException;

@NotThreadSafe
public final class BlueprintSession {
    private final Stack<Class<?>> stack = new Stack();
    private final Set<Class<?>> classes = new HashSet();
    private int blueprintCount = 0;

    private void detectCycles(@Nonnull Class<?> clazz) {
        if (this.stack.contains(clazz)) {
            throw new BlueprintCycleException(clazz);
        }
    }

    public Set<Class<?>> getBlueprintClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    public int getBlueprintCount() {
        return this.blueprintCount;
    }

    public void pop() {
        this.stack.pop();
        ++this.blueprintCount;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public void push(@Nonnull Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        this.detectCycles(clazz);
        this.stack.push(clazz);
        this.classes.add(clazz);
    }
}

