/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitytest.ModifierBits;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintInvocationHandler;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;
import net.sf.qualitytest.blueprint.SafeInvoke;
import net.sf.qualitytest.blueprint.configuration.DefaultBlueprintConfiguration;
import net.sf.qualitytest.blueprint.configuration.RandomBlueprintConfiguration;
import net.sf.qualitytest.exception.BlueprintException;
import net.sf.qualitytest.exception.NoPublicConstructorException;

public final class Blueprint {
    private static final BlueprintConfiguration DEFAULT_CONFIG = new DefaultBlueprintConfiguration();

    @Throws(value={IllegalNullArgumentException.class})
    private static <T> T bean(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config, @Nonnull BlueprintSession session) {
        Check.notNull(clazz, (String)"clazz");
        Check.notNull((Object)config, (String)"config");
        Check.notNull((Object)session, (String)"sesion");
        T obj = Blueprint.safeNewInstance(clazz);
        Blueprint.blueprintPublicMethods(obj, clazz, config, session);
        Blueprint.blueprintPublicAttributes(obj, clazz, config, session);
        return obj;
    }

    private static void blueprintField(final Object that, final Field f, BlueprintConfiguration config, BlueprintSession session) {
        CreationStrategy<?> creator = config.findCreationStrategyForType(f.getType());
        final Object value = Blueprint.blueprintObject(f.getType(), config, creator, session);
        SafeInvoke.invoke(new SafeInvoke.ExceptionRunnable<Object>(){

            @Override
            public Object run() throws Exception {
                f.set(that, value);
                return null;
            }
        }, BlueprintException.class);
    }

    private static void blueprintMethod(final Object that, final Method m, BlueprintConfiguration config, BlueprintSession session) {
        CreationStrategy<?> creator = config.findCreationStrategyForMethod(m);
        if (creator != null) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            final Object[] values = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                values[i] = creator.createValue(parameterTypes[i], config, session);
            }
            SafeInvoke.invoke(new SafeInvoke.ExceptionRunnable<Object>(){

                @Override
                public Object run() throws Exception {
                    m.invoke(that, values);
                    return null;
                }
            }, BlueprintException.class);
        }
    }

    @Nullable
    private static <T> T blueprintObject(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config, @Nullable CreationStrategy<?> creator, @Nonnull BlueprintSession session) {
        if (creator != null) {
            return (T)creator.createValue(clazz, config, session);
        }
        if (clazz.isInterface()) {
            return Blueprint.proxy(clazz, config, session);
        }
        if (Blueprint.hasPublicDefaultConstructor(clazz)) {
            return Blueprint.bean(clazz, config, session);
        }
        return Blueprint.immutable(clazz, config, session);
    }

    private static <T> void blueprintPublicAttributes(T obj, Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        if (!config.isWithPublicAttributes()) {
            return;
        }
        for (Field f : clazz.getFields()) {
            boolean isStatic = ModifierBits.isModifierBitSet(f.getModifiers(), 8);
            boolean isFinal = ModifierBits.isModifierBitSet(f.getModifiers(), 16);
            if (isStatic || isFinal) continue;
            Blueprint.blueprintField(obj, f, config, session);
        }
    }

    private static <T> void blueprintPublicMethods(T obj, Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        for (Method m : clazz.getMethods()) {
            if (!Blueprint.isRelevant(m)) continue;
            Blueprint.blueprintMethod(obj, m, config, session);
        }
    }

    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T construct(@Nonnull Class<T> clazz) {
        Check.notNull(clazz, (String)"clazz");
        return Blueprint.construct(clazz, DEFAULT_CONFIG, new BlueprintSession());
    }

    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T construct(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config) {
        Check.notNull(clazz, (String)"clazz");
        Check.notNull((Object)config, (String)"config");
        return Blueprint.construct(clazz, config, new BlueprintSession());
    }

    @Nullable
    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T construct(@Nonnull Class<T> clazz, @Nonnull BlueprintConfiguration config, @Nonnull BlueprintSession session) {
        Check.notNull(clazz, (String)"clazz");
        Check.notNull((Object)config, (String)"config");
        Check.notNull((Object)session, (String)"session");
        CreationStrategy<?> creator = config.findCreationStrategyForType(clazz);
        session.push(clazz);
        T ret = Blueprint.blueprintObject(clazz, config, creator, session);
        session.pop();
        return ret;
    }

    public static BlueprintConfiguration def() {
        return new DefaultBlueprintConfiguration();
    }

    private static <T> Constructor<?> findFirstPublicConstructor(Class<T> clazz) {
        int i$ = 0;
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?>[] arr$ = constructors;
        int len$ = arr$.length;
        if (i$ < len$) {
            Constructor<?> c = arr$[i$];
            return c;
        }
        return null;
    }

    private static boolean hasPublicDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = clazz.getConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static <T> T immutable(Class<T> clazz, BlueprintConfiguration config, BlueprintSession session) {
        Constructor<?> constructor = Blueprint.findFirstPublicConstructor(clazz);
        if (constructor == null) {
            throw new NoPublicConstructorException(clazz.getSimpleName());
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = Blueprint.construct(parameterTypes[i], config, session);
        }
        T obj = Blueprint.safeNewInstance(constructor, parameters);
        Blueprint.blueprintPublicMethods(obj, clazz, config, session);
        Blueprint.blueprintPublicAttributes(obj, clazz, config, session);
        return obj;
    }

    protected static boolean isRelevant(Method m) {
        boolean isNotStatic = !ModifierBits.isModifierBitSet(m.getModifiers(), 8);
        boolean isPublic = ModifierBits.isModifierBitSet(m.getModifiers(), 1);
        return isNotStatic && isPublic;
    }

    private static <T> T proxy(Class<T> iface, BlueprintConfiguration config, BlueprintSession session) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new BlueprintInvocationHandler(config, session));
    }

    public static BlueprintConfiguration random() {
        return new RandomBlueprintConfiguration();
    }

    private static <T> T safeNewInstance(final Class<T> clazz) {
        return SafeInvoke.invoke(new SafeInvoke.ExceptionRunnable<T>(){

            @Override
            public T run() throws Exception {
                return clazz.newInstance();
            }
        }, BlueprintException.class);
    }

    private static <T> T safeNewInstance(final Constructor<?> constructor, final Object[] parameters) {
        return SafeInvoke.invoke(new SafeInvoke.ExceptionRunnable<T>(){

            @Override
            public T run() throws Exception {
                return constructor.newInstance(parameters);
            }
        }, BlueprintException.class);
    }

    private Blueprint() {
    }
}

