/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.sf.qualitytest.exception.IllegalClassWithPublicDefaultConstructorException;
import net.sf.qualitytest.exception.IllegalMissingAnnotationOnMethodException;
import net.sf.qualitytest.exception.IllegalNonFinalClassException;
import net.sf.qualitytest.exception.IllegalNonFinalStaticException;

public final class StaticCheck {
    public static Class<?> classIsFinal(@Nonnull Class<?> clazz) {
        boolean isFinal = StaticCheck.isModifierBitSet(clazz.getModifiers(), 16);
        if (!isFinal) {
            throw new IllegalNonFinalClassException(clazz.getName());
        }
        return clazz;
    }

    public static Class<?> publicMethodsAnnotated(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation) {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (m.isAnnotationPresent(annotation)) continue;
            throw new IllegalMissingAnnotationOnMethodException(clazz, annotation, m);
        }
        return clazz;
    }

    public static Class<?> noNonFinalStatic(@Nonnull Class<?> clazz) {
        Field[] fields;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (f.isSynthetic() || !StaticCheck.isStaticAndNotFinal(f)) continue;
            throw new IllegalNonFinalStaticException(clazz.getName(), f.getName());
        }
        return clazz;
    }

    public static Class<?> noNonFinalStaticInHierarchy(@Nonnull Class<?> clazz) {
        Class<?> obj = clazz;
        do {
            StaticCheck.noNonFinalStatic(obj);
        } while ((obj = obj.getSuperclass()) != null);
        return clazz;
    }

    public static Class<?> noPublicDefaultConstructor(@Nonnull Class<?> clazz) {
        try {
            clazz.newInstance();
            throw new IllegalClassWithPublicDefaultConstructorException(clazz.getName());
        }
        catch (InstantiationException e) {
            throw new IllegalClassWithPublicDefaultConstructorException(clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            return clazz;
        }
    }

    private static boolean isStaticAndNotFinal(Field f) {
        int modifiers = f.getModifiers();
        boolean isStatic = StaticCheck.isModifierBitSet(modifiers, 8);
        boolean isFinal = StaticCheck.isModifierBitSet(modifiers, 16);
        return isStatic && !isFinal;
    }

    private static boolean isModifierBitSet(int modifiers, int modifier) {
        return (modifiers & modifier) == modifier;
    }

    private StaticCheck() {
    }
}

