/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalArgumentNotContainedException;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalInstanceOfArgumentException;
import net.sf.qualitycheck.exception.IllegalMissingAnnotationException;
import net.sf.qualitycheck.exception.IllegalNaNArgumentException;
import net.sf.qualitycheck.exception.IllegalNegativeArgumentException;
import net.sf.qualitycheck.exception.IllegalNotEqualException;
import net.sf.qualitycheck.exception.IllegalNotGreaterThanException;
import net.sf.qualitycheck.exception.IllegalNotLesserThanException;
import net.sf.qualitycheck.exception.IllegalNotNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullElementsException;
import net.sf.qualitycheck.exception.IllegalNumberArgumentException;
import net.sf.qualitycheck.exception.IllegalNumericArgumentException;
import net.sf.qualitycheck.exception.IllegalPatternArgumentException;
import net.sf.qualitycheck.exception.IllegalPositionIndexException;
import net.sf.qualitycheck.exception.IllegalRangeException;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.qualitycheck.exception.RuntimeInstantiationException;

public final class ConditionalCheck {
    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalArgumentNotContainedException.class})
    public static <T> T contains(boolean condition, @Nonnull Collection<T> haystack, @Nonnull T needle) {
        if (condition) {
            Check.contains(haystack, needle);
        }
        return needle;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalArgumentNotContainedException.class})
    public static <T> T contains(boolean condition, @Nonnull Collection<T> haystack, @Nonnull T needle, @Nonnull String name) {
        if (condition) {
            Check.contains(haystack, needle, name);
        }
        return needle;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static boolean equals(boolean condition, @Nonnull boolean expected, @Nonnull boolean check) {
        if (condition) {
            Check.equals(expected, check);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static boolean equals(boolean condition, @Nonnull boolean expected, @Nonnull boolean check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static byte equals(boolean condition, @Nonnull byte expected, @Nonnull byte check) {
        if (condition) {
            Check.equals(expected, check);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static byte equals(boolean condition, @Nonnull byte expected, @Nonnull byte check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static char equals(boolean condition, @Nonnull char expected, @Nonnull char check) {
        if (condition) {
            Check.equals(expected, check);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static char equals(boolean condition, @Nonnull char expected, @Nonnull char check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static int equals(boolean condition, @Nonnull int expected, @Nonnull int check) {
        if (condition) {
            Check.equals(expected, check);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static int equals(boolean condition, @Nonnull int expected, @Nonnull int check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static long equals(boolean condition, @Nonnull long expected, @Nonnull long check) {
        if (condition) {
            Check.equals(expected, check);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static long equals(boolean condition, @Nonnull long expected, @Nonnull long check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static short equals(boolean condition, @Nonnull short expected, @Nonnull short check) {
        if (condition) {
            Check.equals(expected, check);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static short equals(boolean condition, @Nonnull short expected, @Nonnull short check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T> T equals(boolean condition, @Nonnull T expected, @Nonnull T check) {
        if (condition) {
            return Check.equals(expected, check);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T> T equals(boolean condition, @Nonnull T expected, @Nonnull T check, String msg) {
        if (condition) {
            return Check.equals(expected, check);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterThanException.class})
    public static <T extends Comparable<T>> T greaterThan(boolean condition, @Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.greaterThan(expected, check);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterThanException.class})
    public static <T extends Comparable<T>> T greaterThan(boolean condition, @Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.greaterThan(expected, check, message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalMissingAnnotationException.class})
    public static Annotation hasAnnotation(boolean condition, @Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation) {
        Check.notNull(clazz, "clazz");
        Check.notNull(annotation, "annotation");
        if (condition) {
            return Check.hasAnnotation(clazz, annotation);
        }
        return clazz.getAnnotation(annotation);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalInstanceOfArgumentException.class})
    public static <T> T instanceOf(boolean condition, @Nonnull Class<?> type, @Nonnull Object obj) {
        if (condition) {
            return Check.instanceOf(type, obj);
        }
        return (T)obj;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalInstanceOfArgumentException.class})
    public static <T> T instanceOf(boolean condition, @Nonnull Class<?> type, @Nonnull Object obj, @Nullable String name) {
        if (condition) {
            return Check.instanceOf(type, obj, name);
        }
        return (T)obj;
    }

    @Throws(value={IllegalNotNullArgumentException.class})
    public static void isNull(boolean condition, @Nullable Object reference) {
        if (condition) {
            Check.isNull(reference);
        }
    }

    @Throws(value={IllegalNotNullArgumentException.class})
    public static void isNull(boolean condition, @Nullable Object reference, @Nullable String name) {
        if (condition) {
            Check.isNull(reference, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static void isNumber(boolean condition, @Nonnull String value) {
        if (condition) {
            Check.isNumber(value);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends Number> void isNumber(boolean condition, @Nonnull String value, @Nonnull Class<T> type) {
        if (condition) {
            Check.isNumber(value, type);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static void isNumber(boolean condition, @Nonnull String value, @Nullable String name) {
        if (condition) {
            Check.isNumber(value, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends Number> void isNumber(boolean condition, @Nonnull String value, @Nullable String name, @Nonnull Class<T> type) {
        if (condition) {
            Check.isNumber(value, name, type);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends CharSequence> T isNumeric(boolean condition, @Nonnull T value) {
        if (condition) {
            return Check.isNumeric(value);
        }
        return value;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumericArgumentException.class})
    public static <T extends CharSequence> T isNumeric(boolean condition, @Nonnull T value, @Nullable String name) {
        if (condition) {
            return Check.isNumeric(value, name);
        }
        return value;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotLesserThanException.class})
    public static <T extends Comparable<T>> T lesserThan(boolean condition, @Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.lesserThan(expected, check);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotLesserThanException.class})
    public static <T extends Comparable<T>> T lesserThan(boolean condition, @Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.lesserThan(expected, check, message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static <T extends CharSequence> T matchesPattern(boolean condition, @Nonnull Pattern pattern, @Nonnull T chars) {
        if (condition) {
            return Check.matchesPattern(pattern, chars);
        }
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalPatternArgumentException.class})
    public static <T extends CharSequence> T matchesPattern(boolean condition, @Nonnull Pattern pattern, @Nonnull T chars, @Nullable String name) {
        if (condition) {
            return Check.matchesPattern(pattern, chars, name);
        }
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T extends Iterable<?>> T noNullElements(boolean condition, @Nonnull T iterable) {
        if (condition) {
            return Check.noNullElements(iterable);
        }
        return iterable;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T extends Iterable<?>> T noNullElements(boolean condition, @Nonnull T iterable, String name) {
        if (condition) {
            return Check.noNullElements(iterable, name);
        }
        return iterable;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T> T[] noNullElements(boolean condition, @Nonnull T[] array) {
        if (condition) {
            return Check.noNullElements(array);
        }
        return array;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T> T[] noNullElements(boolean condition, @Nonnull T[] array, @Nullable String name) {
        if (condition) {
            return Check.noNullElements(array, name);
        }
        return array;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean condition, boolean expression) {
        if (condition) {
            Check.notEmpty(expression);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean condition, boolean expression, @Nullable String name) {
        if (condition) {
            Check.notEmpty(expression, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> T notEmpty(boolean condition, @Nonnull T chars) {
        if (condition) {
            return Check.notEmpty(chars);
        }
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(boolean condition, @Nonnull T collection) {
        if (condition) {
            return Check.notEmpty(collection);
        }
        return collection;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(boolean condition, @Nonnull T map) {
        if (condition) {
            return Check.notEmpty(map);
        }
        return map;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T notEmpty(boolean condition, @Nonnull T reference, boolean expression, @Nullable String name) {
        if (condition) {
            return Check.notEmpty(reference, expression, name);
        }
        return reference;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> T notEmpty(boolean condition, @Nonnull T chars, @Nullable String name) {
        if (condition) {
            return Check.notEmpty(chars, name);
        }
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(boolean condition, @Nonnull T map, @Nullable String name) {
        if (condition) {
            return Check.notEmpty(map, name);
        }
        return map;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(boolean condition, @Nonnull T collection, @Nullable String name) {
        if (condition) {
            return Check.notEmpty(collection, name);
        }
        return collection;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(boolean condition, @Nonnull T[] array) {
        if (condition) {
            return Check.notEmpty(array);
        }
        return array;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(boolean condition, @Nonnull T[] array, @Nullable String name) {
        if (condition) {
            return Check.notEmpty(array, name);
        }
        return array;
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static double notNaN(boolean condition, double value) {
        if (condition) {
            return Check.notNaN(value);
        }
        return value;
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static double notNaN(boolean condition, double value, @Nullable String name) {
        if (condition) {
            return Check.notNaN(value, name);
        }
        return value;
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static float notNaN(boolean condition, float value) {
        if (condition) {
            return Check.notNaN(value);
        }
        return value;
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static float notNaN(boolean condition, float value, @Nullable String name) {
        if (condition) {
            return Check.notNaN(value, name);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static int notNegative(boolean condition, @Nonnull int value) {
        if (condition) {
            return Check.notNegative(value);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static int notNegative(boolean condition, @Nonnull int value, @Nullable String name) {
        if (condition) {
            return Check.notNegative(value, name);
        }
        return value;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(boolean condition, @Nonnull T reference) {
        if (condition) {
            return Check.notNull(reference);
        }
        return reference;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(boolean condition, @Nonnull T reference, @Nullable String name) {
        if (condition) {
            return Check.notNull(reference, name);
        }
        return reference;
    }

    @Throws(value={IllegalPositionIndexException.class})
    public static int positionIndex(boolean condition, int index, int size) {
        if (condition) {
            return Check.positionIndex(index, size);
        }
        return index;
    }

    @Throws(value={IllegalRangeException.class})
    public static void range(boolean condition, @Nonnegative int start, @Nonnegative int end, @Nonnegative int size) {
        if (condition) {
            Check.range(start, end, size);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean condition, boolean expression) {
        if (condition) {
            Check.stateIsTrue(expression);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, RuntimeInstantiationException.class})
    public static void stateIsTrue(boolean condition, boolean expression, Class<? extends RuntimeException> clazz) {
        if (condition) {
            Check.stateIsTrue(expression, clazz);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean condition, boolean expression, @Nonnull String description) {
        if (condition) {
            Check.stateIsTrue(expression, description);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean condition, boolean expression, @Nonnull String descriptionTemplate, Object ... descriptionTemplateArgs) {
        if (condition) {
            Check.stateIsTrue(expression, descriptionTemplate, descriptionTemplateArgs);
        }
    }

    private ConditionalCheck() {
    }
}

