/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceCodeFormatter {
    public static final Properties DEFAULT_PROPERTIES = SourceCodeFormatter.findDefaultProperties();
    private static final String DEFAULT_PROPERTIES_PATH = "org.eclipse.jdt.core.prefs";
    private static final Logger LOG = LoggerFactory.getLogger(SourceCodeFormatter.class);

    @Nonnull
    private static Properties findDefaultProperties() {
        InputStream in = SourceCodeFormatter.class.getClassLoader().getResourceAsStream(DEFAULT_PROPERTIES_PATH);
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can not load resource %s", DEFAULT_PROPERTIES_PATH));
        }
        return p;
    }

    public static String format(String code) {
        return SourceCodeFormatter.format(code, DEFAULT_PROPERTIES, LineEnding.DEFAULT_LINE_ENDING);
    }

    public static String format(String code, Properties options, LineEnding lineEnding) {
        Check.notEmpty((CharSequence)code, (String)"code");
        Check.notEmpty((Map)options, (String)"options");
        Check.notNull((Object)((Object)lineEnding), (String)"lineEnding");
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)options);
        String lineSeparator = LineEnding.find(lineEnding, code);
        TextEdit te = null;
        try {
            te = formatter.format(8, code, 0, code.length(), 0, lineSeparator);
        }
        catch (Exception formatFailed) {
            LOG.warn("Formatting failed", (Throwable)formatFailed);
        }
        String formattedCode = code;
        if (te == null) {
            LOG.info("Code cannot be formatted. Possible cause is unmatched source/target/compliance version.");
        } else {
            Document doc = new Document(code);
            try {
                te.apply((IDocument)doc);
            }
            catch (Exception e) {
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            }
            formattedCode = doc.get();
        }
        return formattedCode;
    }

    private SourceCodeFormatter() {
    }

    public static enum LineEnding {
        KEEP(""),
        CR("\r"),
        CRLF("\r\n"),
        LF("\n");

        public static final LineEnding DEFAULT_LINE_ENDING;
        private final String _chars;

        @Nonnull
        private static LineEnding determine(String code) {
            Check.notNull((Object)code, (String)"code");
            int lfCount = 0;
            int crCount = 0;
            int crlfCount = 0;
            for (int i = 0; i < code.length(); ++i) {
                char c = code.charAt(i);
                if (c == '\r') {
                    if (i + 1 < code.length() && code.charAt(i + 1) == '\n') {
                        ++crlfCount;
                        ++i;
                        continue;
                    }
                    ++crCount;
                    continue;
                }
                if (c != '\n') continue;
                ++lfCount;
            }
            if (lfCount > crCount && lfCount > crlfCount) {
                return LF;
            }
            if (crlfCount > lfCount && crlfCount > crCount) {
                return CRLF;
            }
            if (crCount > lfCount && crCount > crlfCount) {
                return CR;
            }
            return KEEP;
        }

        @Nonnull
        public static String find(@Nonnull LineEnding lineEnding, @Nonnull String code) {
            Check.notNull((Object)((Object)lineEnding), (String)"lineEnding");
            Check.notNull((Object)code, (String)"code");
            String ret = DEFAULT_LINE_ENDING.asString();
            if (KEEP == lineEnding) {
                LineEnding determined = LineEnding.determine(code);
                ret = KEEP == determined ? DEFAULT_LINE_ENDING.asString() : determined.asString();
            } else if (LF == lineEnding) {
                ret = lineEnding.asString();
            } else if (CRLF == lineEnding) {
                ret = lineEnding.asString();
            } else if (CR == lineEnding) {
                ret = lineEnding.asString();
            }
            return ret;
        }

        private LineEnding(String chars) {
            this._chars = chars;
        }

        public String asString() {
            return this._chars;
        }

        public String find(String code) {
            return LineEnding.find(this, code);
        }

        static {
            DEFAULT_LINE_ENDING = LF;
        }
    }
}

