/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.AccessorPrefix;

@ThreadSafe
public final class MethodUtil {
    private static final String METHOD_SET_PREFIX = "set";
    private static final Pattern PATTERN = Pattern.compile("([A-Za-z][A-Za-z0-9]*)");

    public static String determineAccessorName(@Nonnull AccessorPrefix prefix, @Nonnull String fieldName) {
        Check.notNull((Object)prefix, (String)"prefix");
        Check.notEmpty((CharSequence)fieldName, (String)"fieldName");
        Matcher m = PATTERN.matcher(fieldName);
        Check.stateIsTrue((boolean)m.find(), (String)"passed field name '%s' is not applicable", (Object[])new Object[]{fieldName});
        String name = m.group();
        return prefix.getPrefix() + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String determineMutatorName(@Nonnull String fieldName) {
        Check.notEmpty((CharSequence)fieldName, (String)"fieldName");
        Matcher m = PATTERN.matcher(fieldName);
        Check.stateIsTrue((boolean)m.find(), (String)"passed field name '%s' is not applicable", (Object[])new Object[]{fieldName});
        String name = m.group();
        return METHOD_SET_PREFIX + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private MethodUtil() {
    }
}

