/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.generator;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.Type;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Attribute;
import net.sf.qualitycheck.immutableobject.domain.Final;
import net.sf.qualitycheck.immutableobject.domain.Import;
import net.sf.qualitycheck.immutableobject.domain.Imports;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.Method;
import net.sf.qualitycheck.immutableobject.domain.Primitive;
import net.sf.qualitycheck.immutableobject.domain.ReturnType;
import net.sf.qualitycheck.immutableobject.domain.Static;
import net.sf.qualitycheck.immutableobject.domain.Visibility;

@ThreadSafe
final class SourceCodeReader {
    @Nonnull
    public static Method createMethod(@Nonnull MethodDeclaration methodDeclaration, @Nonnull Imports imports) {
        Check.notNull((Object)methodDeclaration, (String)"methodDeclaration");
        Check.notNull((Object)imports, (String)"imports");
        List<Annotation> annotations = SourceCodeReader.findAnnotations(methodDeclaration.getAnnotations(), imports);
        List<Attribute> attributes = SourceCodeReader.findAttributes(methodDeclaration.getParameters(), imports);
        ReturnType returnType = ReturnType.of(SourceCodeReader.findType(methodDeclaration.getType(), imports));
        return new Method(methodDeclaration.getName(), returnType, "throw new NotImplementedException();", attributes, Visibility.PUBLIC, Final.UNDEFINED, Static.UNDEFINED, annotations);
    }

    @Nonnull
    public static List<Annotation> findAnnotations(@Nullable List<AnnotationExpr> annotationExprs, @Nonnull Imports imports) {
        Check.notNull((Object)imports, (String)"imports");
        ArrayList annotations = Lists.newArrayList();
        if (annotationExprs != null) {
            for (AnnotationExpr annotation : annotationExprs) {
                Import imp;
                String name = annotation.getName().toString();
                if (name.isEmpty() || (imp = imports.find(name)) == null) continue;
                annotations.add(new Annotation(imp.getType()));
            }
        }
        return annotations;
    }

    @Nonnull
    public static List<Attribute> findAttributes(@Nullable List<Parameter> parameters, @Nonnull Imports imports) {
        Check.notNull((Object)imports, (String)"imports");
        ArrayList attributes = Lists.newArrayList();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                VariableDeclaratorId var = parameter.getId();
                net.sf.qualitycheck.immutableobject.domain.Type type = SourceCodeReader.findType(parameter.getType(), imports);
                List<Annotation> annotations = SourceCodeReader.findAnnotations(parameter.getAnnotations(), imports);
                attributes.add(new Attribute(var.getName(), type, Final.UNDEFINED, annotations));
            }
        }
        return attributes;
    }

    public static List<Interface> findExtends(@Nonnull ClassOrInterfaceDeclaration type) {
        ArrayList ret = Lists.newArrayList();
        if (type.getExtends() != null) {
            for (ClassOrInterfaceType extend : type.getExtends()) {
                ret.add(Interface.of(extend.getName()));
            }
        }
        return ret;
    }

    @Nonnull
    public static Imports findImports(@Nullable List<ImportDeclaration> importDeclarations) {
        ArrayList imports = Lists.newArrayList();
        if (importDeclarations != null) {
            for (ImportDeclaration importDeclaration : importDeclarations) {
                imports.add(Import.of(importDeclaration.getName().toString()));
            }
        }
        return Imports.copyOf(imports);
    }

    @Nonnull
    public static List<Method> findMethods(@Nonnull List<BodyDeclaration> members, @Nonnull Imports imports) {
        Check.notNull(members, (String)"members");
        Check.notNull((Object)imports, (String)"imports");
        ArrayList methods = Lists.newArrayList();
        for (BodyDeclaration member : members) {
            if (!(member instanceof MethodDeclaration)) continue;
            methods.add(SourceCodeReader.createMethod((MethodDeclaration)member, imports));
        }
        return methods;
    }

    @Nonnull
    public static net.sf.qualitycheck.immutableobject.domain.Type findType(@Nonnull Type type, @Nonnull Imports imports) {
        net.sf.qualitycheck.immutableobject.domain.Type t;
        Import imp;
        Check.notNull((Object)type, (String)"type");
        Check.notNull((Object)imports, (String)"imports");
        net.sf.qualitycheck.immutableobject.domain.Type ret = Primitive.isPrimitive(type.toString()) ? new net.sf.qualitycheck.immutableobject.domain.Type(type.toString()) : ((imp = imports.find((t = new net.sf.qualitycheck.immutableobject.domain.Type(type.toString())).getName())) != null ? new net.sf.qualitycheck.immutableobject.domain.Type(imp.getType().getPackage(), imp.getType().getName(), t.getGenericDeclaration()) : t);
        return ret;
    }

    @Nullable
    static CompilationUnit parse(@Nonnull String code) {
        Check.notNull((Object)code, (String)"code");
        CompilationUnit unit = null;
        try {
            unit = JavaParser.parse((InputStream)new ByteArrayInputStream(code.getBytes(Charsets.UTF_8.displayName())));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Character encoding is not supported: switch to UTF-8");
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse interface: " + e.getLocalizedMessage(), e);
        }
        return unit;
    }

    private SourceCodeReader() {
    }
}

