/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.generator;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.ImmutableInterfaceAnalysis;
import net.sf.qualitycheck.immutableobject.domain.Imports;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.InterfaceAnalysis;
import net.sf.qualitycheck.immutableobject.domain.Method;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.generator.SourceCodeReader;

@ThreadSafe
final class InterfaceAnalyzer {
    @Nonnull
    public static InterfaceAnalysis analyze(@Nonnull String code) {
        Check.notNull((Object)code, (String)"code");
        CompilationUnit unit = (CompilationUnit)Check.notNull((Object)SourceCodeReader.parse(code), (String)"compilationUnit");
        List types = (List)Check.notEmpty((Collection)unit.getTypes(), (String)"typeDeclarations");
        Check.stateIsTrue((types.size() == 1 ? 1 : 0) != 0, (String)"only one interface declaration per analysis is supported");
        ClassOrInterfaceDeclaration type = (ClassOrInterfaceDeclaration)types.get(0);
        Imports imports = SourceCodeReader.findImports(unit.getImports());
        Package pkg = unit.getPackage() != null ? new Package(unit.getPackage().getName().toString()) : Package.UNDEFINED;
        List<Annotation> annotations = SourceCodeReader.findAnnotations(type.getAnnotations(), imports);
        List<Method> methods = SourceCodeReader.findMethods(type.getMembers(), imports);
        Check.stateIsTrue((!InterfaceAnalyzer.hasPossibleMutatingMethods(methods) ? 1 : 0) != 0, (String)"The passed interface '%s' seems to have mutating methods", (Object[])new Object[]{type.getName()});
        List<Interface> extendsInterfaces = SourceCodeReader.findExtends(type);
        String interfaceName = type.getName();
        return new ImmutableInterfaceAnalysis(annotations, extendsInterfaces, imports.asList(), interfaceName, methods, pkg);
    }

    private static boolean hasPossibleMutatingMethods(@Nonnull List<Method> methods) {
        boolean result = false;
        for (Method method : methods) {
            if (method.getAttributes().isEmpty()) continue;
            result = true;
            break;
        }
        return result;
    }

    private InterfaceAnalyzer() {
    }
}

