/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.generator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Abstract;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Clazz;
import net.sf.qualitycheck.immutableobject.domain.Constructor;
import net.sf.qualitycheck.immutableobject.domain.Field;
import net.sf.qualitycheck.immutableobject.domain.Final;
import net.sf.qualitycheck.immutableobject.domain.GenericDeclaration;
import net.sf.qualitycheck.immutableobject.domain.ImmutableSettings;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.InterfaceAnalysis;
import net.sf.qualitycheck.immutableobject.domain.Method;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.domain.Settings;
import net.sf.qualitycheck.immutableobject.domain.Static;
import net.sf.qualitycheck.immutableobject.domain.Type;
import net.sf.qualitycheck.immutableobject.domain.Visibility;
import net.sf.qualitycheck.immutableobject.generator.ImmutableObjectRenderer;
import net.sf.qualitycheck.immutableobject.generator.ImmutableObjectTestRenderer;
import net.sf.qualitycheck.immutableobject.generator.InterfaceAnalyzer;
import net.sf.qualitycheck.immutableobject.generator.SerialVersionGenerator;
import net.sf.qualitycheck.immutableobject.util.FieldUtil;
import net.sf.qualitycheck.immutableobject.util.SourceCodeFormatter;

@ThreadSafe
public final class ImmutableObjectGenerator {
    public static final String CLAZZ_PREFIX = "Immutable";

    @Nonnull
    private static List<Field> findFields(@Nonnull List<Method> methods) {
        ArrayList fields = Lists.newArrayList();
        for (Method method : methods) {
            List<Annotation> annotations = method.getAnnotations();
            fields.add(new Field(FieldUtil.determineFieldName(method.getName()), method.getReturnType().getType(), Visibility.PRIVATE, Final.FINAL, Static.UNDEFINED, annotations, "", FieldUtil.determineAccessorPrefix(method.getName())));
        }
        return fields;
    }

    public static Result generate(@Nonnull String code, @Nonnull ImmutableSettings settings) {
        Check.notNull((Object)code, (String)"code");
        ImmutableSettings.Builder settingsBuilder = new ImmutableSettings.Builder((Settings)Check.notNull((Object)settings, (String)"settings"));
        InterfaceAnalysis analysis = InterfaceAnalyzer.analyze(code);
        Clazz clazz = ImmutableObjectGenerator.scaffoldClazz(analysis, settings);
        settingsBuilder.fields(clazz.getFields());
        settingsBuilder.immutableName(clazz.getName());
        settingsBuilder.imports(clazz.getImports());
        Interface definition = new Interface(new Type(clazz.getPackage(), analysis.getInterfaceName(), GenericDeclaration.UNDEFINED));
        settingsBuilder.mainInterface(definition);
        settingsBuilder.interfaces(clazz.getInterfaces());
        settingsBuilder.packageDeclaration(clazz.getPackage());
        String implementationCode = SourceCodeFormatter.format(ImmutableObjectRenderer.toString(clazz, settingsBuilder.build()));
        String testCode = SourceCodeFormatter.format(ImmutableObjectTestRenderer.toString(clazz, settingsBuilder.build()));
        return new Result(implementationCode, testCode);
    }

    private static boolean isSerializable(@Nonnull List<Interface> interfaces) {
        boolean ret = false;
        for (Interface extend : interfaces) {
            if (!"Serializable".equals(extend.getType().getName())) continue;
            ret = true;
        }
        return ret;
    }

    @Nonnull
    private static Clazz scaffoldClazz(@Nonnull InterfaceAnalysis analysis, @Nonnull ImmutableSettings settings) {
        String name;
        Package pkg = analysis.getPackage();
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (settings.isReplacement()) {
            name = analysis.getInterfaceName();
        } else {
            name = CLAZZ_PREFIX + analysis.getInterfaceName();
            interfaces.add(new Interface(new Type(pkg, analysis.getInterfaceName(), GenericDeclaration.UNDEFINED)));
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (settings.isSerializable() || ImmutableObjectGenerator.isSerializable(analysis.getExtends())) {
            interfaces.add(Interface.of(Serializable.class));
            fields.add(SerialVersionGenerator.generate());
        }
        fields.addAll(ImmutableObjectGenerator.findFields(analysis.getMethods()));
        ImmutableList constructors = ImmutableList.of();
        return new Clazz(name, pkg, fields, (List<Constructor>)constructors, analysis.getMethods(), Visibility.PUBLIC, Final.FINAL, Abstract.UNDEFINED, interfaces, analysis.getImports(), analysis.getAnnotations());
    }

    private ImmutableObjectGenerator() {
    }

    @Immutable
    public static class Result {
        @Nonnull
        private final String implementationCode;
        @Nonnull
        private final String testCode;

        private Result(@Nonnull String implementationCode, @Nonnull String testCode) {
            this.implementationCode = (String)Check.notNull((Object)implementationCode, (String)"implementationCode");
            this.testCode = (String)Check.notNull((Object)testCode, (String)"testCode");
        }

        @Nonnull
        public String getImplCode() {
            return this.implementationCode;
        }

        @Nonnull
        public String getTestCode() {
            return this.testCode;
        }
    }
}

