/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.generator;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.CollectionVariant;
import net.sf.qualitycheck.immutableobject.domain.Field;
import net.sf.qualitycheck.immutableobject.domain.ImmutableSettings;
import net.sf.qualitycheck.immutableobject.domain.ReservedWord;
import net.sf.qualitycheck.immutableobject.domain.Static;
import net.sf.qualitycheck.immutableobject.domain.Type;
import net.sf.qualitycheck.immutableobject.generator.BasicFormatRenderer;
import org.stringtemplate.v4.AttributeRenderer;

@ThreadSafe
final class FieldRenderer
implements AttributeRenderer {
    private static final String CHECK_NONNEGATIVE = "Check.notNegative(%s, \"%s\")";
    private static final String CHECK_NONNULL = "Check.notNull(%s, \"%s\")";
    @Nonnull
    private final ImmutableSettings _settings;

    @Nonnull
    private static String convertIfReservedWord(@Nonnull String name) {
        return ReservedWord.isReserved(name) ? name + "1" : name;
    }

    @Nonnull
    public static final String determineGeneric(@Nonnull Type type) {
        return type.getGenericDeclaration().isUndefined() ? "" : "<" + type.getGenericDeclaration().getDeclaration() + ">";
    }

    @Nonnull
    static String surroundWithCheck(@Nonnull Field field, @Nonnull String referenceAccess) {
        Check.notEmpty((CharSequence)referenceAccess, (String)"referenceAccess");
        String result = referenceAccess;
        if (field.isNonnegative()) {
            result = String.format(CHECK_NONNEGATIVE, result, result);
        } else if (field.isNonnull()) {
            result = String.format(CHECK_NONNULL, result, result);
        }
        return result;
    }

    public FieldRenderer(@Nonnull ImmutableSettings settings) {
        this._settings = (ImmutableSettings)Check.notNull((Object)settings, (String)"settings");
    }

    @Nonnull
    String copyCollection(@Nonnull Field field, @Nonnull String currentResult) {
        String result = currentResult;
        CollectionVariant variant = CollectionVariant.evaluate(field.getType());
        if (variant != null) {
            if (this._settings.hasGuava()) {
                result = String.format(variant.getGuavaCopy(), result);
            } else {
                String generic = FieldRenderer.determineGeneric(field.getType());
                result = String.format(variant.getDefaultCopy(), generic, result);
            }
        }
        return result;
    }

    @Nonnull
    String makeCollectionImmutable(@Nonnull Field field, @Nonnull String currentResult) {
        String result = currentResult;
        CollectionVariant variant = CollectionVariant.evaluate(field.getType());
        if (variant != null) {
            if (this._settings.hasGuava()) {
                result = String.format(variant.getGuavaImmutable(), result);
            } else {
                String generic = FieldRenderer.determineGeneric(field.getType());
                result = String.format(variant.getDefaultImmutable(), generic, result);
            }
        }
        return result;
    }

    private String regardPrefix(Field field, Option option) {
        return Static.STATIC != field.getStatic() && option != Option.ATTRIBUTE ? this._settings.getFieldPrefix() + field.getName() : field.getName();
    }

    @Nonnull
    public String toString(Object o, String formatOption, Locale locale) {
        Field field = (Field)o;
        Option option = formatOption != null ? Option.evaluate(formatOption) : Option.UNDEFINED;
        String result = FieldRenderer.convertIfReservedWord(this.regardPrefix(field, option));
        if (option == Option.COPY || option == Option.COPY_FROM_INTERFACE || option == Option.IMMUTABLE) {
            if (Option.COPY_FROM_INTERFACE == option) {
                String argumentName = BasicFormatRenderer.toLowerCamelCase(this._settings.getMainInterface().getType().getName());
                result = argumentName + "." + field.getAccessorMethodName() + "()";
            } else {
                result = FieldRenderer.convertIfReservedWord(field.getName());
            }
            if (this._settings.hasQualityCheck()) {
                result = FieldRenderer.surroundWithCheck(field, result);
            }
            if (option == Option.IMMUTABLE) {
                result = this.makeCollectionImmutable(field, result);
            } else if (option == Option.COPY || option == Option.COPY_FROM_INTERFACE) {
                result = this.copyCollection(field, result);
            }
        }
        return result;
    }

    public static enum Option {
        ATTRIBUTE,
        COPY,
        COPY_FROM_INTERFACE,
        IMMUTABLE,
        UNDEFINED;


        @Nonnull
        public static Option evaluate(@Nonnull String option) {
            Check.notNull((Object)option, (String)"option");
            Option ret = UNDEFINED;
            for (Option value : Option.values()) {
                if (!value.toString().equals(option.trim().toUpperCase())) continue;
                ret = value;
                break;
            }
            return ret;
        }
    }
}

