/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.ReservedWord;

public enum Primitive {
    BOOLEAN(ReservedWord.BOOLEAN.getWord()),
    BYTE(ReservedWord.BYTE.getWord()),
    LONG(ReservedWord.LONG.getWord()),
    INT(ReservedWord.INT.getWord()),
    DOUBLE(ReservedWord.DOUBLE.getWord()),
    FLOAT(ReservedWord.FLOAT.getWord()),
    CHAR(ReservedWord.CHAR.getWord()),
    SHORT(ReservedWord.SHORT.getWord());

    private final String _name;

    public static boolean isPrimitive(String name) {
        Check.notNull((Object)name, (String)"name");
        boolean ret = false;
        for (Primitive p : Primitive.values()) {
            if (!p._name.equals(name)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private Primitive(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }
}

