/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Characters;

@Immutable
public final class Package
implements Characters {
    public static final Package UNDEFINED = new Package();
    public static final Package JAVA_LANG = new Package("java.lang");
    private static final String PREFIX = "package";
    @Nonnull
    private final String _name;

    private static String removeLastDot(String packageName) {
        return packageName.charAt(packageName.length() - 1) == '.' ? packageName.substring(0, packageName.length() - 1) : packageName;
    }

    private Package() {
        this._name = "";
    }

    public Package(@Nonnull String packageName) {
        Check.notEmpty((CharSequence)packageName, (String)"packageName");
        this._name = (String)Check.notEmpty((CharSequence)Package.removeLastDot(packageName.trim()), (String)"packageName");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Package other = (Package)obj;
        return this._name.equals(other._name);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._name.hashCode();
        return result;
    }

    public boolean isUndefined() {
        return UNDEFINED.equals(this);
    }

    public String toString() {
        return "package " + this._name;
    }
}

