/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Attribute;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Final;
import net.sf.qualitycheck.immutableobject.domain.GenericDeclaration;
import net.sf.qualitycheck.immutableobject.domain.ReturnType;
import net.sf.qualitycheck.immutableobject.domain.Static;
import net.sf.qualitycheck.immutableobject.domain.Visibility;

@Immutable
public final class Method
implements Characters {
    public static final String NOT_IMPLEMENTED = "throw new NotImplementedException();";
    @Nonnull
    private final List<Annotation> _annotations;
    @Nonnull
    private final List<Attribute> _attributes;
    @Nonnull
    private final String _content;
    @Nonnull
    private final Final _final;
    @Nonnull
    private final String _name;
    @Nonnull
    private final ReturnType _returnType;
    @Nonnull
    private final Static _static;
    @Nonnull
    private final Visibility _visibility;

    public Method(@Nonnull String name, @Nonnull ReturnType returnType, String content, @Nonnull List<Attribute> attributes, @Nonnull Visibility visibility, @Nonnull Final finalModifier, @Nonnull Static staticModifier, @Nonnull List<Annotation> annotations) {
        this._name = (String)Check.notEmpty((CharSequence)name, (String)"name");
        this._returnType = (ReturnType)Check.notNull((Object)returnType, (String)"returnType");
        this._content = (String)Check.notEmpty((CharSequence)content, (String)"content");
        this._attributes = ImmutableList.copyOf((Collection)((Collection)Check.notNull(attributes, (String)"attributes")));
        this._visibility = (Visibility)Check.notNull((Object)visibility, (String)"visibility");
        this._final = (Final)Check.notNull((Object)finalModifier, (String)"finalModifier");
        this._static = (Static)Check.notNull((Object)staticModifier, (String)"staticModifier");
        this._annotations = ImmutableList.copyOf((Collection)((Collection)Check.notNull(annotations, (String)"annotations")));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        if (!((Object)this._annotations).equals(other._annotations)) {
            return false;
        }
        if (!((Object)this._attributes).equals(other._attributes)) {
            return false;
        }
        if (!this._content.equals(other._content)) {
            return false;
        }
        if (this._final != other._final) {
            return false;
        }
        if (!this._name.equals(other._name)) {
            return false;
        }
        if (!this._returnType.equals(other._returnType)) {
            return false;
        }
        if (this._static != other._static) {
            return false;
        }
        return this._visibility == other._visibility;
    }

    @Nonnull
    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    public List<Attribute> getAttributes() {
        return this._attributes;
    }

    public String getContent() {
        return this._content;
    }

    @Nonnull
    public Final getFinal() {
        return this._final;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public ReturnType getReturnType() {
        return this._returnType;
    }

    public Static getStatic() {
        return this._static;
    }

    @Nonnull
    public Visibility getVisibility() {
        return this._visibility;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this._annotations).hashCode();
        result = 31 * result + ((Object)this._attributes).hashCode();
        result = 31 * result + this._content.hashCode();
        result = 31 * result + this._final.hashCode();
        result = 31 * result + this._name.hashCode();
        result = 31 * result + this._returnType.hashCode();
        result = 31 * result + this._static.hashCode();
        result = 31 * result + this._visibility.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this._annotations.isEmpty()) {
            for (Annotation annotation : this._annotations) {
                b.append('@');
                b.append(annotation.getType().getName());
                b.append('\n');
            }
        }
        if (this._visibility != Visibility.UNDEFINED) {
            b.append(this._visibility.getName());
            b.append(' ');
        }
        if (this._static != Static.UNDEFINED) {
            b.append(this._static.getName());
            b.append(' ');
        }
        if (this._final != Final.UNDEFINED) {
            b.append(this._final.getName());
            b.append(' ');
        }
        b.append(this._returnType.getType().getName());
        if (this._returnType.getType().getGenericDeclaration() != GenericDeclaration.UNDEFINED) {
            b.append('<');
            b.append(this._returnType.getType().getGenericDeclaration());
            b.append('>');
        }
        b.append(' ');
        b.append(this._name);
        b.append('(');
        if (!this._attributes.isEmpty()) {
            b.append(Joiner.on((String)", ").join(this._attributes));
        }
        b.append(')');
        b.append(' ');
        b.append('{');
        b.append('\n');
        b.append(this._content);
        b.append('\n');
        b.append('}');
        return b.toString();
    }
}

