/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Type;

@Immutable
public final class Interface {
    public static final Interface UNDEFINED = new Interface();
    @Nonnull
    final Type _type;

    public static Interface of(@Nonnull Class<?> interfaceType) {
        Check.notNull(interfaceType, (String)"interfaceType");
        Check.stateIsTrue((boolean)interfaceType.isInterface(), (String)"requires an interface");
        return new Interface(Type.of(interfaceType));
    }

    public static Interface of(@Nonnull String interfaceType) {
        Check.notEmpty((CharSequence)interfaceType, (String)"interfaceType");
        return new Interface(new Type(interfaceType));
    }

    public Interface() {
        this._type = new Type("void");
    }

    public Interface(Type interfaceType) {
        this._type = (Type)Check.notNull((Object)interfaceType, (String)"interfaceType");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interface other = (Interface)obj;
        return this._type.equals(other._type);
    }

    public Type getType() {
        return this._type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._type.hashCode();
        return result;
    }

    public String toString() {
        return this._type.getName();
    }
}

