/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.AccessorPrefix;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Final;
import net.sf.qualitycheck.immutableobject.domain.GenericDeclaration;
import net.sf.qualitycheck.immutableobject.domain.Static;
import net.sf.qualitycheck.immutableobject.domain.Type;
import net.sf.qualitycheck.immutableobject.domain.Visibility;
import net.sf.qualitycheck.immutableobject.util.MethodUtil;

public final class Field
implements Characters {
    public static final String WITHOUT_VALUE = "";
    @Nonnull
    private final transient String _accessorMethodName;
    @Nonnull
    private final AccessorPrefix _accessorPrefix;
    @Nonnull
    private final List<Annotation> _annotations;
    @Nonnull
    private final Final _final;
    @Nonnull
    private final transient String _mutatorMethodName;
    @Nonnull
    private final String _name;
    @Nonnull
    private final Static _static;
    @Nonnull
    private final Type _type;
    @Nonnull
    private final String _value;
    @Nonnull
    private final Visibility _visibility;

    public Field(@Nonnull String name, @Nonnull Type type, @Nonnull Visibility visibility, @Nonnull Final finalModifier, Static staticModifier, @Nonnull List<Annotation> annotations, @Nonnull String value, AccessorPrefix accessorPrefix) {
        this._name = (String)Check.notNull((Object)name, (String)"name");
        this._type = (Type)Check.notNull((Object)type, (String)"type");
        this._visibility = (Visibility)Check.notNull((Object)visibility, (String)"visibility");
        this._final = (Final)Check.notNull((Object)finalModifier, (String)"finalModifier");
        this._static = (Static)Check.notNull((Object)staticModifier, (String)"staticModifier");
        this._annotations = ImmutableList.copyOf((Collection)((Collection)Check.notNull(annotations, (String)"annotations")));
        this._value = (String)Check.notNull((Object)value, (String)"value");
        this._accessorPrefix = (AccessorPrefix)Check.notNull((Object)accessorPrefix, (String)"accessorPrefix");
        this._accessorMethodName = MethodUtil.determineAccessorName(accessorPrefix, name);
        this._mutatorMethodName = MethodUtil.determineMutatorName(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        if (!((Object)this._annotations).equals(other._annotations)) {
            return false;
        }
        if (this._final != other._final) {
            return false;
        }
        if (!this._name.equals(other._name)) {
            return false;
        }
        if (!this._type.equals(other._type)) {
            return false;
        }
        return this._visibility == other._visibility;
    }

    public String getAccessorMethodName() {
        return this._accessorMethodName;
    }

    public AccessorPrefix getAccessorPrefix() {
        return this._accessorPrefix;
    }

    @Nonnull
    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    @Nonnull
    public Final getFinal() {
        return this._final;
    }

    public String getMutatorMethodName() {
        return this._mutatorMethodName;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public Static getStatic() {
        return this._static;
    }

    @Nonnull
    public Type getType() {
        return this._type;
    }

    public String getValue() {
        return this._value;
    }

    @Nonnull
    public Visibility getVisibility() {
        return this._visibility;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this._annotations).hashCode();
        result = 31 * result + this._final.hashCode();
        result = 31 * result + this._name.hashCode();
        result = 31 * result + this._type.hashCode();
        result = 31 * result + this._visibility.hashCode();
        return result;
    }

    public boolean isNonnegative() {
        return this._annotations.contains(Annotation.NONNEGATIVE);
    }

    public boolean isNonnull() {
        return this._annotations.contains(Annotation.NONNULL);
    }

    public boolean isNullable() {
        return this._annotations.contains(Annotation.NULLABLE) || !this.isNonnull() && !this.isNonnegative();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this._annotations.isEmpty()) {
            for (Annotation annotation : this._annotations) {
                b.append(annotation.toString());
                b.append('\n');
            }
        }
        if (this._visibility != Visibility.UNDEFINED) {
            b.append(this._visibility.getName());
            b.append(' ');
        }
        if (this._static != Static.UNDEFINED) {
            b.append(this._static.getName());
            b.append(' ');
        }
        if (this._final != Final.UNDEFINED) {
            b.append(this._final.getName());
            b.append(' ');
        }
        b.append(this._type.getName());
        if (this._type.getGenericDeclaration() != GenericDeclaration.UNDEFINED) {
            b.append('<');
            b.append(this._type.getGenericDeclaration());
            b.append('>');
        }
        b.append(' ');
        b.append(this._name);
        if (!this._value.isEmpty()) {
            b.append('=');
            b.append(this._value);
        }
        b.append(';');
        return b.toString();
    }
}

