/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Attribute;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Visibility;

@Immutable
public final class Constructor
implements Characters {
    public static final String NOT_IMPLEMENTED = "throw new NotImplementedException();";
    @Nonnull
    private final List<Annotation> _annotations;
    @Nonnull
    private final List<Attribute> _attributes;
    @Nonnull
    private final String _content;
    @Nonnull
    private final String _name;
    @Nonnull
    private final Visibility _visibility;

    public Constructor(@Nonnull String name, @Nonnull String content, @Nonnull List<Attribute> attributes, @Nonnull Visibility visibility, @Nonnull List<Annotation> annotations) {
        this._name = (String)Check.notEmpty((CharSequence)name, (String)"name");
        this._content = (String)Check.notNull((Object)content, (String)"content");
        this._attributes = (List)Check.notNull(attributes, (String)"attributes");
        this._visibility = (Visibility)Check.notNull((Object)visibility, (String)"visibility");
        this._annotations = (List)Check.notNull(annotations, (String)"annotations");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constructor other = (Constructor)obj;
        if (!((Object)this._annotations).equals(other._annotations)) {
            return false;
        }
        if (!((Object)this._attributes).equals(other._attributes)) {
            return false;
        }
        if (!this._content.equals(other._content)) {
            return false;
        }
        if (!this._name.equals(other._name)) {
            return false;
        }
        return this._visibility == other._visibility;
    }

    @Nonnull
    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    @Nonnull
    public List<Attribute> getAttributes() {
        return this._attributes;
    }

    public String getContent() {
        return this._content;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public Visibility getVisibility() {
        return this._visibility;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this._annotations).hashCode();
        result = 31 * result + ((Object)this._attributes).hashCode();
        result = 31 * result + this._content.hashCode();
        result = 31 * result + this._name.hashCode();
        result = 31 * result + this._visibility.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this._annotations.isEmpty()) {
            for (Annotation annotation : this._annotations) {
                b.append('@');
                b.append(annotation.getType().getName());
                b.append('\n');
            }
        }
        if (this._visibility != Visibility.UNDEFINED) {
            b.append(this._visibility.getName());
            b.append(' ');
        }
        b.append(this._name);
        b.append('(');
        if (!this._attributes.isEmpty()) {
            b.append(Joiner.on((String)", ").join(this._attributes));
        }
        b.append(')');
        b.append(' ');
        b.append('{');
        b.append('\n');
        b.append(this._content);
        b.append('\n');
        b.append('}');
        return b.toString();
    }
}

