/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Abstract;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Annotations;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Constructor;
import net.sf.qualitycheck.immutableobject.domain.Field;
import net.sf.qualitycheck.immutableobject.domain.Final;
import net.sf.qualitycheck.immutableobject.domain.Import;
import net.sf.qualitycheck.immutableobject.domain.Imports;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.Method;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.domain.Visibility;

@Immutable
public final class Clazz
implements Characters {
    private static final String PREFIX = "class";
    @Nonnull
    private final List<Annotation> _annotations;
    @Nonnull
    private final Abstract _abstract;
    @Nonnull
    private final List<Interface> _interfaces;
    @Nonnull
    private final List<Constructor> _constructors;
    @Nonnull
    private final List<Field> _fields;
    @Nonnull
    private final Final _final;
    @Nonnull
    private final List<Method> _methods;
    @Nonnull
    private final String _name;
    @Nonnull
    private final Package _package;
    @Nonnull
    private final List<Import> _imports;
    @Nonnull
    private final Visibility _visibility;

    public Clazz(String name, Package pkg, List<Field> fields, List<Constructor> constructors, List<Method> methods, Visibility visibility, Final finalModifier, Abstract abstractModifier, List<Interface> interfaces, List<Import> imports, @Nonnull List<Annotation> annotations) {
        this._name = (String)Check.notEmpty((CharSequence)name, (String)"name");
        this._package = (Package)Check.notNull((Object)pkg, (String)"pkg");
        this._abstract = (Abstract)Check.notNull((Object)abstractModifier, (String)"abstractModifier");
        this._fields = ImmutableList.copyOf((Collection)((Collection)Check.notNull(fields, (String)"fields")));
        this._constructors = ImmutableList.copyOf((Collection)((Collection)Check.notNull(constructors, (String)"constructors")));
        this._methods = ImmutableList.copyOf((Collection)((Collection)Check.notNull(methods, (String)"methods")));
        this._visibility = (Visibility)Check.notNull((Object)visibility, (String)"visibility");
        this._final = (Final)Check.notNull((Object)finalModifier, (String)"finalModifier");
        this._interfaces = ImmutableList.copyOf((Collection)((Collection)Check.notNull(interfaces, (String)"interfaces")));
        this._imports = ImmutableList.copyOf((Collection)((Collection)Check.notNull(imports, (String)"imports")));
        Check.notNull(annotations, (String)"annotations");
        this._annotations = ImmutableList.copyOf(Annotations.of(annotations).removeUnqualified(this._imports).getAnnotations());
        Check.stateIsTrue((!this.abstractAndFinal() ? 1 : 0) != 0, (String)"A class can be either abstract or final, not both.");
    }

    private boolean abstractAndFinal() {
        return this._abstract == Abstract.ABSTRACT && this._final == Final.FINAL;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Clazz other = (Clazz)obj;
        if (this._abstract != other._abstract) {
            return false;
        }
        if (!((Object)this._annotations).equals(other._annotations)) {
            return false;
        }
        if (!((Object)this._constructors).equals(other._constructors)) {
            return false;
        }
        if (!((Object)this._fields).equals(other._fields)) {
            return false;
        }
        if (this._final != other._final) {
            return false;
        }
        if (!((Object)this._interfaces).equals(other._interfaces)) {
            return false;
        }
        if (!((Object)this._methods).equals(other._methods)) {
            return false;
        }
        if (!this._name.equals(other._name)) {
            return false;
        }
        if (!this._package.equals(other._package)) {
            return false;
        }
        return this._visibility == other._visibility;
    }

    public Abstract getAbstract() {
        return this._abstract;
    }

    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    public List<Constructor> getConstructors() {
        return this._constructors;
    }

    public List<Field> getFields() {
        return this._fields;
    }

    public Final getFinal() {
        return this._final;
    }

    public List<Import> getImports() {
        return Imports.copyOf(this._imports).copyAndAdd(Imports.allOf(this)).filter().sortByName().asList();
    }

    public List<Interface> getInterfaces() {
        return this._interfaces;
    }

    public List<Method> getMethods() {
        return this._methods;
    }

    public String getName() {
        return this._name;
    }

    public Package getPackage() {
        return this._package;
    }

    public Visibility getVisibility() {
        return this._visibility;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._abstract.hashCode();
        result = 31 * result + ((Object)this._annotations).hashCode();
        result = 31 * result + ((Object)this._constructors).hashCode();
        result = 31 * result + ((Object)this._fields).hashCode();
        result = 31 * result + this._final.hashCode();
        result = 31 * result + ((Object)this._interfaces).hashCode();
        result = 31 * result + ((Object)this._methods).hashCode();
        result = 31 * result + this._name.hashCode();
        result = 31 * result + this._package.hashCode();
        result = 31 * result + this._visibility.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!Package.UNDEFINED.equals(this._package)) {
            b.append(this._package.toString());
            b.append(';');
            b.append('\n');
        }
        b.append('\n');
        List<Import> imports = this.getImports();
        for (Import imp : imports) {
            b.append(imp.toString());
            b.append('\n');
        }
        b.append('\n');
        if (!this._annotations.isEmpty()) {
            for (Annotation annotation : this._annotations) {
                b.append('@');
                b.append(annotation.getType().getName());
                b.append('\n');
            }
        }
        if (this._visibility != Visibility.UNDEFINED) {
            b.append(this._visibility.getName());
            b.append(' ');
        }
        if (this._final != Final.UNDEFINED) {
            b.append(this._final.getName());
            b.append(' ');
        }
        b.append(PREFIX);
        b.append(' ');
        b.append(this._name);
        b.append(' ');
        if (!this._interfaces.isEmpty()) {
            b.append("implements");
            b.append(' ');
            b.append(Joiner.on((String)", ").join(this._interfaces));
            b.append(' ');
        }
        b.append('{');
        b.append('\n');
        b.append('\n');
        if (!this._fields.isEmpty()) {
            for (Field field : this._fields) {
                b.append(field.toString());
                b.append('\n');
                b.append('\n');
            }
        }
        if (!this._constructors.isEmpty()) {
            for (Constructor constructor : this._constructors) {
                b.append(constructor.toString());
                b.append('\n');
                b.append('\n');
            }
        }
        if (!this._methods.isEmpty()) {
            for (Method method : this._methods) {
                b.append(method.toString());
                b.append('\n');
                b.append('\n');
            }
        }
        b.append('}');
        b.append('\n');
        return b.toString();
    }
}

