/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Final;
import net.sf.qualitycheck.immutableobject.domain.GenericDeclaration;
import net.sf.qualitycheck.immutableobject.domain.Type;

@Immutable
public final class Attribute
implements Characters {
    private final List<Annotation> _annotations;
    private final Final _final;
    private final String _name;
    private final Type _type;

    public Attribute(@Nonnull String name, @Nonnull Type type, @Nonnull Final finalModifier, @Nonnull List<Annotation> annotations) {
        this._name = (String)Check.notNull((Object)name, (String)"name");
        this._type = (Type)Check.notNull((Object)type, (String)"type");
        this._final = (Final)Check.notNull((Object)finalModifier, (String)"finalModifier");
        this._annotations = (List)Check.notNull(annotations, (String)"annotations");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (!((Object)this._annotations).equals(other._annotations)) {
            return false;
        }
        if (this._final != other._final) {
            return false;
        }
        if (!this._name.equals(other._name)) {
            return false;
        }
        return this._type.equals(other._type);
    }

    @Nonnull
    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    @Nonnull
    public Final getFinal() {
        return this._final;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public Type getType() {
        return this._type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this._annotations).hashCode();
        result = 31 * result + this._final.hashCode();
        result = 31 * result + this._name.hashCode();
        result = 31 * result + this._type.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this._annotations.isEmpty()) {
            for (Annotation annotation : this._annotations) {
                b.append('@');
                b.append(annotation.getType().getName());
                b.append(' ');
            }
        }
        if (this._final != Final.UNDEFINED) {
            b.append(this._final.getName());
            b.append(' ');
        }
        b.append(this._type.getName());
        if (this._type.getGenericDeclaration() != GenericDeclaration.UNDEFINED) {
            b.append('<');
            b.append(this._type.getGenericDeclaration());
            b.append('>');
        }
        b.append(' ');
        b.append(this._name);
        return b.toString();
    }
}

