/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Import;
import net.sf.qualitycheck.immutableobject.domain.Imports;
import net.sf.qualitycheck.immutableobject.domain.Package;

@Immutable
public final class Annotations {
    @Nonnull
    private final List<Annotation> _annotations;

    @Nonnull
    public static Annotations of(@Nonnull Iterable<Annotation> annotations) {
        Check.notNull(annotations, (String)"annotations");
        return new Annotations(annotations);
    }

    @Nonnull
    private static Set<Annotation> removeUnqualified(@Nonnull List<Annotation> annotations, @Nonnull Imports imports) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Annotation annotation : annotations) {
            if (annotation.getType().getPackage() == Package.UNDEFINED) {
                Import imp = imports.find(annotation.getType().getName());
                if (imp == null) continue;
                result.add(new Annotation(imp.getType()));
                continue;
            }
            result.add(annotation);
        }
        return result;
    }

    private Annotations(@Nonnull Iterable<Annotation> annotations) {
        Check.notNull(annotations, (String)"annotations");
        this._annotations = ImmutableList.copyOf(annotations);
    }

    @Nonnull
    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    @Nonnull
    public Annotations removeUnqualified(@Nonnull List<Import> imports) {
        Check.notNull(imports, (String)"imports");
        return Annotations.of(Annotations.removeUnqualified(this.getAnnotations(), Imports.copyOf(imports)));
    }
}

