/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Type;

@Immutable
public final class Annotation
implements Characters {
    public static final Annotation IMMUTABLE = Annotation.of(Immutable.class);
    public static final Annotation NONNEGATIVE = Annotation.of(Nonnegative.class);
    public static final Annotation NONNULL = Annotation.of(Nonnull.class);
    public static final Annotation NOT_THREAD_SAFE = Annotation.of(NotThreadSafe.class);
    public static final Annotation NULLABLE = Annotation.of(Nullable.class);
    final Type _type;

    public static Annotation of(@Nonnull Class<?> annotationType) {
        Check.notNull(annotationType, (String)"annotationType");
        Check.stateIsTrue((boolean)annotationType.isAnnotation(), (String)"requires an annotation");
        return new Annotation(Type.of(annotationType));
    }

    public static Annotation of(@Nonnull java.lang.annotation.Annotation annotation) {
        Check.notNull((Object)annotation, (String)"annotation");
        return new Annotation(Type.of(annotation.annotationType()));
    }

    public static Annotation of(@Nonnull String annotationType) {
        Check.notEmpty((CharSequence)annotationType, (String)"annotationType");
        return new Annotation(new Type(annotationType));
    }

    public Annotation(Type annotationType) {
        this._type = (Type)Check.notNull((Object)annotationType, (String)"annotationType");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return this._type.equals(other._type);
    }

    public Type getType() {
        return this._type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._type.hashCode();
        return result;
    }

    public boolean isImmutable() {
        return IMMUTABLE.equals(this);
    }

    public boolean isNonnegative() {
        return NONNEGATIVE.equals(this);
    }

    public boolean isNonnull() {
        return NONNULL.equals(this);
    }

    public boolean isNotThreadSafe() {
        return NOT_THREAD_SAFE.equals(this);
    }

    public boolean isNullable() {
        return NULLABLE.equals(this);
    }

    public String toString() {
        return '@' + this._type.getName();
    }
}

