/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.AccessorPrefix;

public final class FieldUtil {
    private static final Pattern PATTERN = Pattern.compile("^(get|has|is)([A-Z]\\w+)");

    public static AccessorPrefix determineAccessorPrefix(@Nonnull String methodName) {
        Check.notEmpty((CharSequence)methodName, (String)"methodName");
        Matcher m = PATTERN.matcher(methodName);
        Check.stateIsTrue((boolean)m.find(), (String)"passed method name '%s' is not applicable", (Object[])new Object[]{methodName});
        return new AccessorPrefix(m.group(1));
    }

    public static String determineFieldName(@Nonnull String methodName) {
        Check.notEmpty((CharSequence)methodName, (String)"methodName");
        Matcher m = PATTERN.matcher(methodName);
        Check.stateIsTrue((boolean)m.find(), (String)"passed method name '%s' is not applicable", (Object[])new Object[]{methodName});
        return m.group(2).substring(0, 1).toLowerCase() + m.group(2).substring(1);
    }

    private FieldUtil() {
    }
}

