/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.generator;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import org.stringtemplate.v4.AttributeRenderer;

@ThreadSafe
final class BasicFormatRenderer
implements AttributeRenderer {
    BasicFormatRenderer() {
    }

    static String toLowerCamelCase(@Nonnull String text) {
        String t = (String)Check.notEmpty((CharSequence)text.trim(), (String)"text");
        return t.substring(0, 1).toLowerCase() + t.substring(1, t.length());
    }

    static String toUpperCamelCase(@Nonnull String text) {
        String t = (String)Check.notEmpty((CharSequence)text.trim(), (String)"text");
        return t.substring(0, 1).toUpperCase() + t.substring(1, t.length());
    }

    public String toString(Object o, String formatName, Locale locale) {
        Check.notNull((Object)o, (String)"o");
        String text = (String)Check.instanceOf(String.class, (Object)o);
        String result = text.toString();
        if (!text.trim().isEmpty() && formatName != null) {
            if (formatName.equals("toUpper")) {
                result = text.toString().toUpperCase();
            } else if (formatName.equals("toLower")) {
                result = text.toString().toLowerCase();
            } else if (formatName.equals("toUpperCamelCase")) {
                result = BasicFormatRenderer.toUpperCamelCase(text);
            } else if (formatName.equals("toLowerCamelCase")) {
                result = BasicFormatRenderer.toLowerCamelCase(text);
            } else {
                throw new IllegalStateOfArgumentException("Unsupported format name: " + formatName);
            }
        }
        return result;
    }
}

