/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.CollectionVariant;
import net.sf.qualitycheck.immutableobject.domain.GenericDeclaration;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.domain.Primitive;

@Immutable
public final class Type {
    public static final Type BOOLEAN = new Type(Package.UNDEFINED, Primitive.BOOLEAN.getName(), GenericDeclaration.UNDEFINED);
    public static final Type BOOLEAN_BOXED = new Type(Package.JAVA_LANG, Boolean.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type BYTE = new Type(Package.UNDEFINED, Primitive.BYTE.getName(), GenericDeclaration.UNDEFINED);
    public static final Type BYTE_BOXED = new Type(Package.JAVA_LANG, Byte.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type CHAR = new Type(Package.UNDEFINED, Primitive.CHAR.getName(), GenericDeclaration.UNDEFINED);
    public static final Type CHARACTER_BOXED = new Type(Package.JAVA_LANG, Character.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type DOUBLE = new Type(Package.UNDEFINED, Primitive.DOUBLE.getName(), GenericDeclaration.UNDEFINED);
    public static final Type DOUBLE_BOXED = new Type(Package.JAVA_LANG, Double.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type FLOAT = new Type(Package.UNDEFINED, Primitive.FLOAT.getName(), GenericDeclaration.UNDEFINED);
    public static final Type FLOAT_BOXED = new Type(Package.JAVA_LANG, Float.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type INT = new Type(Package.UNDEFINED, Primitive.INT.getName(), GenericDeclaration.UNDEFINED);
    public static final Type INTEGER_BOXED = new Type(Package.JAVA_LANG, Integer.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type LONG = new Type(Package.UNDEFINED, Primitive.LONG.getName(), GenericDeclaration.UNDEFINED);
    public static final Type LONG_BOXED = new Type(Package.JAVA_LANG, Long.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type NUMBER = new Type(Package.JAVA_LANG, Number.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    private static final Pattern PATTERN = Pattern.compile("^(((\\d|\\w)+\\.)*)((\\d|\\w)+)(\\$((\\d|\\w)+))?(<([\\w\\?].*)>)?$");
    public static final Type SHORT = new Type(Package.UNDEFINED, Primitive.SHORT.getName(), GenericDeclaration.UNDEFINED);
    public static final Type SHORT_BOXED = new Type(Package.JAVA_LANG, Short.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final Type STRING = new Type(Package.JAVA_LANG, String.class.getSimpleName(), GenericDeclaration.UNDEFINED);
    public static final List<Type> JAVA_LANG_VALUE_TYPES = ImmutableList.of((Object)BOOLEAN_BOXED, (Object)BYTE_BOXED, (Object)CHARACTER_BOXED, (Object)DOUBLE_BOXED, (Object)FLOAT_BOXED, (Object)INTEGER_BOXED, (Object)LONG_BOXED, (Object)NUMBER, (Object)SHORT_BOXED, (Object)STRING);
    @Nullable
    private final transient boolean _collectionVariant;
    @Nonnull
    private final GenericDeclaration _genericDeclaration;
    @Nonnull
    private final String _name;
    @Nonnull
    private final Package _package;

    @Nonnull
    private static GenericDeclaration createGenericDeclaration(@Nonnull String declaration) {
        Check.notNull((Object)declaration, (String)"declaration");
        return declaration.isEmpty() ? GenericDeclaration.UNDEFINED : GenericDeclaration.of(declaration);
    }

    @Nonnull
    private static Package createPackage(@Nonnull String packageName) {
        Check.notNull((Object)packageName, (String)"packageName");
        return packageName.isEmpty() ? Package.UNDEFINED : new Package(packageName);
    }

    @Nullable
    public static Type evaluateJavaLangType(@Nonnull String name) {
        Check.notEmpty((CharSequence)name, (String)"name");
        Type ret = null;
        for (Type type : JAVA_LANG_VALUE_TYPES) {
            if (!type.getName().equals(name.replace("java.lang.", ""))) continue;
            ret = type;
            break;
        }
        return ret;
    }

    @Nonnull
    public static Type of(@Nonnull Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        return new Type(clazz.getName());
    }

    public Type(@Nonnull Package pkg, @Nonnull String name, @Nonnull GenericDeclaration genericDeclaration) {
        this._package = (Package)Check.notNull((Object)pkg, (String)"pkg");
        this._name = (String)Check.notEmpty((CharSequence)name, (String)"name");
        this._genericDeclaration = (GenericDeclaration)Check.notNull((Object)genericDeclaration, (String)"genericDeclaration");
        this._collectionVariant = CollectionVariant.evaluate(pkg, name) != null;
    }

    public Type(@Nonnull String qualifiedName) {
        Check.notNull((Object)qualifiedName, (String)"qualifiedName");
        Matcher m = PATTERN.matcher(Check.notEmpty((CharSequence)qualifiedName.trim(), (String)"qualifiedName"));
        Check.stateIsTrue((boolean)m.matches(), (String)"qualified name must match against: %s", (Object[])new Object[]{PATTERN.pattern()});
        Package pkg = m.group(7) != null ? Type.createPackage(m.group(1) + m.group(4)) : Type.createPackage(m.group(1));
        String name = m.group(7) != null ? m.group(7) : (String)Check.notEmpty((CharSequence)m.group(4), (String)"name");
        this._collectionVariant = CollectionVariant.evaluate(pkg, name) != null;
        this._genericDeclaration = m.group(10) != null ? Type.createGenericDeclaration(m.group(10)) : GenericDeclaration.UNDEFINED;
        this._package = pkg;
        this._name = name;
    }

    public Type(@Nonnull String packageName, @Nonnull String typeName, @Nonnull String genericDeclaration) {
        this(Type.createPackage((String)Check.notNull((Object)packageName, (String)"packageName")), (String)Check.notEmpty((CharSequence)typeName, (String)"typeName"), Type.createGenericDeclaration((String)Check.notNull((Object)genericDeclaration, (String)"genericDeclaration")));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        if (!this._genericDeclaration.equals(other._genericDeclaration)) {
            return false;
        }
        if (!this._package.equals(other._package)) {
            return false;
        }
        return this._name.equals(other._name);
    }

    @Nonnull
    public GenericDeclaration getGenericDeclaration() {
        return this._genericDeclaration;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public Package getPackage() {
        return this._package;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._genericDeclaration.hashCode();
        result = 31 * result + this._package.hashCode();
        result = 31 * result + this._name.hashCode();
        return result;
    }

    public boolean isBoolean() {
        return this.equals(BOOLEAN);
    }

    public boolean isBoxedBoolean() {
        return this.equals(BOOLEAN_BOXED);
    }

    public boolean isBoxedByte() {
        return this.equals(BYTE_BOXED);
    }

    public boolean isBoxedCharacter() {
        return this.equals(CHARACTER_BOXED);
    }

    public boolean isBoxedDouble() {
        return this.equals(DOUBLE_BOXED);
    }

    public boolean isBoxedFloat() {
        return this.equals(FLOAT_BOXED);
    }

    public boolean isBoxedInteger() {
        return this.equals(INTEGER_BOXED);
    }

    public boolean isBoxedLong() {
        return this.equals(LONG_BOXED);
    }

    public boolean isBoxedShort() {
        return this.equals(SHORT_BOXED);
    }

    public boolean isBoxedType() {
        return this.isBoxedBoolean() || this.isBoxedByte() || this.isBoxedCharacter() || this.isBoxedDouble() || this.isBoxedFloat() || this.isBoxedInteger() || this.isBoxedLong() || this.isBoxedShort();
    }

    public boolean isByte() {
        return this.equals(BYTE);
    }

    public boolean isChar() {
        return this.equals(CHAR);
    }

    public boolean isCollectionVariant() {
        return this._collectionVariant;
    }

    public boolean isDouble() {
        return this.equals(DOUBLE);
    }

    public boolean isFloat() {
        return this.equals(FLOAT);
    }

    public boolean isInt() {
        return this.equals(INT);
    }

    public boolean isJavaLangType() {
        return this.isBoxedType() || this.isNumber() || this.isString();
    }

    public boolean isLong() {
        return this.equals(LONG);
    }

    public boolean isNumber() {
        return this.equals(NUMBER);
    }

    public boolean isPrimitive() {
        return Primitive.isPrimitive(this._name);
    }

    public boolean isShort() {
        return this.equals(SHORT);
    }

    public boolean isString() {
        return this.equals(STRING);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this._package.getName().isEmpty()) {
            b.append(this._package.getName());
            b.append('.');
        }
        b.append(this._name);
        if (!this._genericDeclaration.getDeclaration().isEmpty()) {
            b.append('<');
            b.append(this._genericDeclaration.getDeclaration());
            b.append('>');
        }
        return b.toString();
    }
}

