/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Type;

@Immutable
public final class ReturnType {
    public static final ReturnType BOOLEAN = ReturnType.of("boolean");
    public static final ReturnType INT = ReturnType.of("int");
    public static final ReturnType VOID = new ReturnType();
    @Nonnull
    private final Type _type;

    public static ReturnType of(@Nonnull Class<?> clazz) {
        return new ReturnType(Type.of((Class)Check.notNull(clazz, (String)"clazz")));
    }

    public static ReturnType of(@Nonnull String type) {
        return new ReturnType(new Type((String)Check.notEmpty((CharSequence)type, (String)"type")));
    }

    public static ReturnType of(@Nonnull Type type) {
        return new ReturnType((Type)Check.notNull((Object)type, (String)"type"));
    }

    private ReturnType() {
        this._type = new Type("void");
    }

    private ReturnType(@Nonnull Type type) {
        this._type = (Type)Check.notNull((Object)type, (String)"type");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReturnType other = (ReturnType)obj;
        return this._type.equals(other._type);
    }

    public Type getType() {
        return this._type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._type.hashCode();
        return result;
    }

    public String toString() {
        return this._type.toString();
    }
}

