/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Attribute;
import net.sf.qualitycheck.immutableobject.domain.Clazz;
import net.sf.qualitycheck.immutableobject.domain.Constructor;
import net.sf.qualitycheck.immutableobject.domain.Field;
import net.sf.qualitycheck.immutableobject.domain.Import;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.Method;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.domain.Type;

@Immutable
public final class Imports {
    private static final Predicate<Import> IGNORE_JAVA_LANG = new Predicate<Import>(){

        public boolean apply(@Nonnull Import imp) {
            return !Package.JAVA_LANG.equals(imp.getType().getPackage());
        }
    };
    private static final Predicate<Import> IGNORE_UNDEFINED = new Predicate<Import>(){

        public boolean apply(@Nonnull Import imp) {
            return !Package.UNDEFINED.equals(imp.getType().getPackage());
        }
    };
    private static final Ordering<Import> ORDER = new Ordering<Import>(){

        public int compare(@Nonnull Import left, @Nonnull Import right) {
            return left.getType().toString().compareTo(right.getType().toString());
        }
    };
    @Nonnull
    private final List<Import> _imports;

    public static Imports allOf(@Nonnull Clazz clazz) {
        Check.notNull((Object)clazz, (String)"clazz");
        ArrayList imports = Lists.newArrayList();
        imports.addAll(Imports.ofAnnotations(clazz.getAnnotations()).asList());
        imports.addAll(Imports.ofConstructors(clazz.getConstructors()).asList());
        imports.addAll(Imports.ofFields(clazz.getFields()).asList());
        imports.addAll(Imports.ofInterfaces(clazz.getInterfaces()).asList());
        imports.addAll(Imports.ofMethods(clazz.getMethods()).asList());
        return new Imports(imports);
    }

    public static Imports allOf(@Nonnull Field field) {
        Check.notNull((Object)field, (String)"field");
        ArrayList imports = Lists.newArrayList();
        imports.add(Import.of(field));
        imports.addAll(Imports.ofAnnotations(field.getAnnotations()).asList());
        return new Imports(imports);
    }

    public static Imports allOf(@Nonnull Method method) {
        Check.notNull((Object)method, (String)"method");
        ArrayList imports = Lists.newArrayList();
        imports.add(Import.of(method.getReturnType().getType()));
        imports.addAll(Imports.ofAnnotations(method.getAnnotations()).asList());
        return new Imports(imports);
    }

    public static Imports copyOf(Iterable<Import> imports) {
        Check.notNull(imports, (String)"imports");
        return new Imports(imports);
    }

    public static Imports of(Import ... imports) {
        Check.notNull((Object)imports, (String)"imports");
        return new Imports(Lists.newArrayList((Object[])imports));
    }

    public static Imports of(Iterable<Import> imports) {
        Check.notNull(imports, (String)"imports");
        return new Imports(Lists.newArrayList(imports));
    }

    private static Imports ofAnnotations(@Nonnull Iterable<Annotation> annotations) {
        Check.notNull(annotations, (String)"annotations");
        ArrayList imports = Lists.newArrayList();
        for (Annotation annotation : annotations) {
            imports.add(Import.of(annotation));
        }
        return new Imports(imports);
    }

    private static Imports ofAttributes(@Nonnull Iterable<Attribute> attributes) {
        Check.notNull(attributes, (String)"attributes");
        ArrayList imports = Lists.newArrayList();
        for (Attribute attribute : attributes) {
            imports.add(Import.of(attribute));
        }
        return new Imports(imports);
    }

    private static Imports ofConstructors(@Nonnull Iterable<Constructor> constructors) {
        Check.notNull(constructors, (String)"attributes");
        ArrayList imports = Lists.newArrayList();
        for (Constructor constructor : constructors) {
            imports.addAll(Imports.ofAnnotations(constructor.getAnnotations()).asList());
            imports.addAll(Imports.ofAttributes(constructor.getAttributes()).asList());
        }
        return new Imports(imports);
    }

    private static Imports ofFields(@Nonnull Iterable<Field> fields) {
        Check.notNull(fields, (String)"fields");
        ArrayList imports = Lists.newArrayList();
        for (Field field : fields) {
            imports.add(Import.of(field));
        }
        return new Imports(imports);
    }

    private static Imports ofInterfaces(@Nonnull Iterable<Interface> interfaces) {
        Check.notNull(interfaces, (String)"interfaces");
        ArrayList imports = Lists.newArrayList();
        for (Interface i : interfaces) {
            imports.add(Import.of(i));
        }
        return new Imports(imports);
    }

    private static Imports ofMethods(@Nonnull Iterable<Method> methods) {
        Check.notNull(methods, (String)"methods");
        ArrayList imports = Lists.newArrayList();
        for (Method method : methods) {
            imports.addAll(Imports.allOf(method).asList());
        }
        return new Imports(imports);
    }

    private Imports(Iterable<Import> imports) {
        Check.notNull(imports, (String)"imports");
        this._imports = ImmutableList.copyOf(imports);
    }

    @Nonnull
    public List<Import> asList() {
        return this._imports;
    }

    @Nonnull
    public Imports copyAndAdd(Collection<Import> imports) {
        Check.notNull(imports, (String)"imports");
        ArrayList internal = Lists.newArrayList(this._imports);
        internal.addAll(imports);
        return new Imports(internal);
    }

    @Nonnull
    public Imports copyAndAdd(Imports imports) {
        Check.notNull((Object)imports, (String)"imports");
        return this.copyAndAdd(imports.asList());
    }

    @Nonnull
    public Imports filter() {
        return new Imports(Sets.newHashSet((Iterable)Collections2.filter(this._imports, (Predicate)Predicates.and(IGNORE_JAVA_LANG, IGNORE_UNDEFINED))));
    }

    @Nullable
    public Import find(@Nonnull String typeName) {
        Type javaLangType;
        Check.notEmpty((CharSequence)typeName, (String)"typeName");
        Import ret = null;
        Type type = new Type(typeName);
        for (Import imp : this._imports) {
            if (!imp.getType().getName().equals(type.getName())) continue;
            ret = imp;
            break;
        }
        if (ret == null && (javaLangType = Type.evaluateJavaLangType(typeName)) != null) {
            ret = Import.of(javaLangType);
        }
        return ret;
    }

    @Nonnull
    public Imports sortByName() {
        ArrayList imports = Lists.newArrayList(this._imports);
        Collections.sort(imports, ORDER.nullsLast());
        return new Imports(imports);
    }
}

