/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Attribute;
import net.sf.qualitycheck.immutableobject.domain.Characters;
import net.sf.qualitycheck.immutableobject.domain.Field;
import net.sf.qualitycheck.immutableobject.domain.GenericDeclaration;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.Type;

@Immutable
public final class Import
implements Characters {
    private static final String PREFIX = "import";
    @Nonnull
    private final Type _type;

    private static Type filterGenericDeclaration(Type type) {
        return type.getGenericDeclaration() == GenericDeclaration.UNDEFINED ? type : new Type(type.getPackage(), type.getName(), GenericDeclaration.UNDEFINED);
    }

    public static Import of(@Nonnull Annotation annotation) {
        Check.notNull((Object)annotation, (String)"annotation");
        return Import.of(annotation.getType());
    }

    public static Import of(@Nonnull Attribute attribute) {
        Check.notNull((Object)attribute, (String)"attribute");
        return Import.of(attribute.getType());
    }

    public static Import of(@Nonnull Class<?> type) {
        Check.notNull(type, (String)"type");
        return Import.of(Type.of(type));
    }

    public static Import of(@Nonnull Field field) {
        Check.notNull((Object)field, (String)"field");
        return Import.of(field.getType());
    }

    public static Import of(@Nonnull Interface interfaceType) {
        Check.notNull((Object)interfaceType, (String)"interfaceType");
        return Import.of(interfaceType.getType());
    }

    public static Import of(@Nonnull String type) {
        return Import.of(new Type((String)Check.notNull((Object)type, (String)"type")));
    }

    public static Import of(@Nonnull Type type) {
        return new Import((Type)Check.notNull((Object)type, (String)"type"));
    }

    private Import(@Nonnull Type type) {
        this._type = Import.filterGenericDeclaration((Type)Check.notNull((Object)type, (String)"type"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Import other = (Import)obj;
        return this._type.equals(other._type);
    }

    public Type getType() {
        return this._type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._type.hashCode();
        return result;
    }

    public String toString() {
        return "import " + this._type.toString() + ';';
    }
}

