/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Field;
import net.sf.qualitycheck.immutableobject.domain.Import;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.domain.Settings;

@Immutable
public final class ImmutableSettings
implements Settings {
    private final boolean builderCopyConstructor;
    private final boolean builderFlatMutators;
    private final boolean builderFluentMutators;
    private final boolean builderImplementsInterface;
    @Nonnull
    private final String builderName;
    private final boolean copyMethods;
    @Nonnull
    private final String fieldPrefix;
    @Nonnull
    private final List<Field> fields;
    private final boolean guava;
    private final boolean hashCodeAndEquals;
    private final boolean hashCodePrecomputation;
    @Nonnull
    private final String immutableName;
    @Nonnull
    private final List<Import> imports;
    @Nonnull
    private final List<Interface> interfaces;
    private final boolean jsr305Annotations;
    @Nonnull
    private final Interface mainInterface;
    @Nonnull
    private final Package packageDeclaration;
    private final boolean qualityCheck;
    private final boolean replacement;
    private final boolean serializable;
    private final boolean toString;

    @Nonnull
    public static ImmutableSettings copyOf(@Nonnull Settings settings) {
        Check.notNull((Object)settings, (String)"settings");
        return new ImmutableSettings(settings.getBuilderName(), settings.getFieldPrefix(), settings.getFields(), settings.getImmutableName(), settings.getImports(), settings.getInterfaces(), settings.getMainInterface(), settings.getPackageDeclaration(), settings.hasBuilderCopyConstructor(), settings.hasBuilderFlatMutators(), settings.hasBuilderFluentMutators(), settings.hasBuilderImplementsInterface(), settings.hasCopyMethods(), settings.hasGuava(), settings.hasHashCodeAndEquals(), settings.hasHashCodePrecomputation(), settings.hasJsr305Annotations(), settings.hasQualityCheck(), settings.hasToString(), settings.isReplacement(), settings.isSerializable());
    }

    @Nonnull
    public static ImmutableSettings copyOnlyIfNecessary(@Nonnull Settings settings) {
        Check.notNull((Object)settings, (String)"settings");
        return settings instanceof ImmutableSettings ? (ImmutableSettings)settings : ImmutableSettings.copyOf(settings);
    }

    public ImmutableSettings(@Nonnull String builderName, @Nonnull String fieldPrefix, @Nonnull List<Field> fields, @Nonnull String immutableName, @Nonnull List<Import> imports, @Nonnull List<Interface> interfaces, @Nonnull Interface mainInterface, @Nonnull Package packageDeclaration, boolean builderCopyConstructor, boolean builderFlatMutators, boolean builderFluentMutators, boolean builderImplementsInterface, boolean copyMethods, boolean guava, boolean hashCodeAndEquals, boolean hashCodePrecomputation, boolean jsr305Annotations, boolean qualityCheck, boolean toString, boolean replacement, boolean serializable) {
        this.builderName = (String)Check.notNull((Object)builderName, (String)"builderName");
        this.fieldPrefix = (String)Check.notNull((Object)fieldPrefix, (String)"fieldPrefix");
        this.fields = ImmutableList.copyOf((Collection)((Collection)Check.notNull(fields, (String)"fields")));
        this.immutableName = (String)Check.notNull((Object)immutableName, (String)"immutableName");
        this.imports = ImmutableList.copyOf((Collection)((Collection)Check.notNull(imports, (String)"imports")));
        this.interfaces = ImmutableList.copyOf((Collection)((Collection)Check.notNull(interfaces, (String)"interfaces")));
        this.mainInterface = (Interface)Check.notNull((Object)mainInterface, (String)"mainInterface");
        this.packageDeclaration = (Package)Check.notNull((Object)packageDeclaration, (String)"packageDeclaration");
        this.builderCopyConstructor = builderCopyConstructor;
        this.builderFlatMutators = builderFlatMutators;
        this.builderFluentMutators = builderFluentMutators;
        this.builderImplementsInterface = builderImplementsInterface;
        this.copyMethods = copyMethods;
        this.guava = guava;
        this.hashCodeAndEquals = hashCodeAndEquals;
        this.hashCodePrecomputation = hashCodePrecomputation;
        this.jsr305Annotations = jsr305Annotations;
        this.qualityCheck = qualityCheck;
        this.toString = toString;
        this.replacement = replacement;
        this.serializable = serializable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableSettings other = (ImmutableSettings)obj;
        return Objects.equal((Object)this.builderName, (Object)other.builderName) && Objects.equal((Object)this.fieldPrefix, (Object)other.fieldPrefix) && Objects.equal(this.fields, other.fields) && Objects.equal((Object)this.immutableName, (Object)other.immutableName) && Objects.equal(this.imports, other.imports) && Objects.equal(this.interfaces, other.interfaces) && Objects.equal((Object)this.mainInterface, (Object)other.mainInterface) && Objects.equal((Object)this.packageDeclaration, (Object)other.packageDeclaration) && Objects.equal((Object)this.builderCopyConstructor, (Object)other.builderCopyConstructor) && Objects.equal((Object)this.builderFlatMutators, (Object)other.builderFlatMutators) && Objects.equal((Object)this.builderFluentMutators, (Object)other.builderFluentMutators) && Objects.equal((Object)this.builderImplementsInterface, (Object)other.builderImplementsInterface) && Objects.equal((Object)this.copyMethods, (Object)other.copyMethods) && Objects.equal((Object)this.guava, (Object)other.guava) && Objects.equal((Object)this.hashCodeAndEquals, (Object)other.hashCodeAndEquals) && Objects.equal((Object)this.hashCodePrecomputation, (Object)other.hashCodePrecomputation) && Objects.equal((Object)this.jsr305Annotations, (Object)other.jsr305Annotations) && Objects.equal((Object)this.qualityCheck, (Object)other.qualityCheck) && Objects.equal((Object)this.toString, (Object)other.toString) && Objects.equal((Object)this.replacement, (Object)other.replacement) && Objects.equal((Object)this.serializable, (Object)other.serializable);
    }

    @Override
    @Nonnull
    public String getBuilderName() {
        return this.builderName;
    }

    @Override
    @Nonnull
    public String getFieldPrefix() {
        return this.fieldPrefix;
    }

    @Override
    @Nonnull
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @Nonnull
    public String getImmutableName() {
        return this.immutableName;
    }

    @Override
    @Nonnull
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    @Nonnull
    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    @Override
    @Nonnull
    public Interface getMainInterface() {
        return this.mainInterface;
    }

    @Override
    @Nonnull
    public Package getPackageDeclaration() {
        return this.packageDeclaration;
    }

    @Override
    public boolean hasBuilderCopyConstructor() {
        return this.builderCopyConstructor;
    }

    @Override
    public boolean hasBuilderFlatMutators() {
        return this.builderFlatMutators;
    }

    @Override
    public boolean hasBuilderFluentMutators() {
        return this.builderFluentMutators;
    }

    @Override
    public boolean hasBuilderImplementsInterface() {
        return this.builderImplementsInterface;
    }

    @Override
    public boolean hasCopyMethods() {
        return this.copyMethods;
    }

    @Override
    public boolean hasGuava() {
        return this.guava;
    }

    @Override
    public boolean hasHashCodeAndEquals() {
        return this.hashCodeAndEquals;
    }

    @Override
    public boolean hasHashCodePrecomputation() {
        return this.hashCodePrecomputation;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.builderName, this.fieldPrefix, this.fields, this.immutableName, this.imports, this.interfaces, this.mainInterface, this.packageDeclaration, this.builderCopyConstructor, this.builderFlatMutators, this.builderFluentMutators, this.builderImplementsInterface, this.copyMethods, this.guava, this.hashCodeAndEquals, this.hashCodePrecomputation, this.jsr305Annotations, this.qualityCheck, this.toString, this.replacement, this.serializable});
    }

    @Override
    public boolean hasJsr305Annotations() {
        return this.jsr305Annotations;
    }

    @Override
    public boolean hasQualityCheck() {
        return this.qualityCheck;
    }

    @Override
    public boolean hasToString() {
        return this.toString;
    }

    @Override
    public boolean isReplacement() {
        return this.replacement;
    }

    @Override
    public boolean isSerializable() {
        return this.serializable;
    }

    @NotThreadSafe
    public static final class Builder {
        private boolean builderCopyConstructor;
        private boolean builderFlatMutators;
        private boolean builderFluentMutators;
        private boolean builderImplementsInterface;
        @Nonnull
        private String builderName = "Builder";
        private boolean copyMethods;
        @Nonnull
        private String fieldPrefix = "";
        @Nonnull
        private List<Field> fields = Lists.newArrayList();
        private boolean guava;
        private boolean hashCodeAndEquals;
        private boolean hashCodePrecomputation;
        @Nonnull
        private String immutableName = "ImmutableUnknownObject";
        @Nonnull
        private List<Import> imports = Lists.newArrayList();
        @Nonnull
        private List<Interface> interfaces = Lists.newArrayList();
        private boolean jsr305Annotations;
        @Nonnull
        private Interface mainInterface = Interface.UNDEFINED;
        @Nonnull
        private Package packageDeclaration = Package.UNDEFINED;
        private boolean qualityCheck;
        private boolean replacement;
        private boolean serializable;
        private boolean toString;

        public Builder() {
        }

        public Builder(@Nonnull Settings settings) {
            Check.notNull((Object)settings, (String)"settings");
            this.builderName = (String)Check.notNull((Object)settings.getBuilderName(), (String)"settings.getBuilderName()");
            this.fieldPrefix = (String)Check.notNull((Object)settings.getFieldPrefix(), (String)"settings.getFieldPrefix()");
            this.fields = Lists.newArrayList((Iterable)((Iterable)Check.notNull(settings.getFields(), (String)"settings.getFields()")));
            this.immutableName = (String)Check.notNull((Object)settings.getImmutableName(), (String)"settings.getImmutableName()");
            this.imports = Lists.newArrayList((Iterable)((Iterable)Check.notNull(settings.getImports(), (String)"settings.getImports()")));
            this.interfaces = Lists.newArrayList((Iterable)((Iterable)Check.notNull(settings.getInterfaces(), (String)"settings.getInterfaces()")));
            this.mainInterface = (Interface)Check.notNull((Object)settings.getMainInterface(), (String)"settings.getMainInterface()");
            this.packageDeclaration = (Package)Check.notNull((Object)settings.getPackageDeclaration(), (String)"settings.getPackageDeclaration()");
            this.builderCopyConstructor = settings.hasBuilderCopyConstructor();
            this.builderFlatMutators = settings.hasBuilderFlatMutators();
            this.builderFluentMutators = settings.hasBuilderFluentMutators();
            this.builderImplementsInterface = settings.hasBuilderImplementsInterface();
            this.copyMethods = settings.hasCopyMethods();
            this.guava = settings.hasGuava();
            this.hashCodeAndEquals = settings.hasHashCodeAndEquals();
            this.hashCodePrecomputation = settings.hasHashCodePrecomputation();
            this.jsr305Annotations = settings.hasJsr305Annotations();
            this.qualityCheck = settings.hasQualityCheck();
            this.toString = settings.hasToString();
            this.replacement = settings.isReplacement();
            this.serializable = settings.isSerializable();
        }

        @Nonnull
        public ImmutableSettings build() {
            return new ImmutableSettings(this.builderName, this.fieldPrefix, this.fields, this.immutableName, this.imports, this.interfaces, this.mainInterface, this.packageDeclaration, this.builderCopyConstructor, this.builderFlatMutators, this.builderFluentMutators, this.builderImplementsInterface, this.copyMethods, this.guava, this.hashCodeAndEquals, this.hashCodePrecomputation, this.jsr305Annotations, this.qualityCheck, this.toString, this.replacement, this.serializable);
        }

        @Nonnull
        public Builder builderCopyConstructor(boolean builderCopyConstructor) {
            this.builderCopyConstructor = builderCopyConstructor;
            return this;
        }

        @Nonnull
        public Builder builderFlatMutators(boolean builderFlatMutators) {
            this.builderFlatMutators = builderFlatMutators;
            return this;
        }

        @Nonnull
        public Builder builderFluentMutators(boolean builderFluentMutators) {
            this.builderFluentMutators = builderFluentMutators;
            return this;
        }

        @Nonnull
        public Builder builderImplementsInterface(boolean builderImplementsInterface) {
            this.builderImplementsInterface = builderImplementsInterface;
            return this;
        }

        @Nonnull
        public Builder builderName(@Nonnull String builderName) {
            this.builderName = (String)Check.notNull((Object)builderName, (String)"builderName");
            return this;
        }

        @Nonnull
        public Builder copyMethods(boolean copyMethods) {
            this.copyMethods = copyMethods;
            return this;
        }

        @Nonnull
        public Builder fieldPrefix(@Nonnull String fieldPrefix) {
            this.fieldPrefix = (String)Check.notNull((Object)fieldPrefix, (String)"fieldPrefix");
            return this;
        }

        @Nonnull
        public Builder fields(@Nonnull List<Field> fields) {
            this.fields = Lists.newArrayList((Iterable)((Iterable)Check.notNull(fields, (String)"fields")));
            return this;
        }

        @Nonnull
        public Builder guava(boolean guava) {
            this.guava = guava;
            return this;
        }

        @Nonnull
        public Builder hashCodeAndEquals(boolean hashCodeAndEquals) {
            this.hashCodeAndEquals = hashCodeAndEquals;
            return this;
        }

        @Nonnull
        public Builder hashCodePrecomputation(boolean hashCodePrecomputation) {
            this.hashCodePrecomputation = hashCodePrecomputation;
            return this;
        }

        @Nonnull
        public Builder immutableName(@Nonnull String immutableName) {
            this.immutableName = (String)Check.notNull((Object)immutableName, (String)"immutableName");
            return this;
        }

        @Nonnull
        public Builder imports(@Nonnull List<Import> imports) {
            this.imports = Lists.newArrayList((Iterable)((Iterable)Check.notNull(imports, (String)"imports")));
            return this;
        }

        @Nonnull
        public Builder interfaces(@Nonnull List<Interface> interfaces) {
            this.interfaces = Lists.newArrayList((Iterable)((Iterable)Check.notNull(interfaces, (String)"interfaces")));
            return this;
        }

        @Nonnull
        public Builder jsr305Annotations(boolean jsr305Annotations) {
            this.jsr305Annotations = jsr305Annotations;
            return this;
        }

        @Nonnull
        public Builder mainInterface(@Nonnull Interface mainInterface) {
            this.mainInterface = (Interface)Check.notNull((Object)mainInterface, (String)"mainInterface");
            return this;
        }

        @Nonnull
        public Builder packageDeclaration(@Nonnull Package packageDeclaration) {
            this.packageDeclaration = (Package)Check.notNull((Object)packageDeclaration, (String)"packageDeclaration");
            return this;
        }

        @Nonnull
        public Builder qualityCheck(boolean qualityCheck) {
            this.qualityCheck = qualityCheck;
            return this;
        }

        @Nonnull
        public Builder replacement(boolean replacement) {
            this.replacement = replacement;
            return this;
        }

        @Nonnull
        public Builder serializable(boolean serializable) {
            this.serializable = serializable;
            return this;
        }

        @Nonnull
        public Builder toString(boolean toString) {
            this.toString = toString;
            return this;
        }
    }
}

