/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Annotation;
import net.sf.qualitycheck.immutableobject.domain.Import;
import net.sf.qualitycheck.immutableobject.domain.Interface;
import net.sf.qualitycheck.immutableobject.domain.InterfaceAnalysis;
import net.sf.qualitycheck.immutableobject.domain.Method;
import net.sf.qualitycheck.immutableobject.domain.Package;

@Immutable
public final class ImmutableInterfaceAnalysis
implements InterfaceAnalysis {
    @Nonnull
    private final List<Annotation> annotations;
    @Nonnull
    private final List<Interface> extends1;
    @Nonnull
    private final List<Import> imports;
    @Nonnull
    private final String interfaceName;
    @Nonnull
    private final List<Method> methods;
    @Nonnull
    private final Package package1;

    @Nonnull
    public static ImmutableInterfaceAnalysis copyOf(@Nonnull InterfaceAnalysis interfaceanalysis) {
        Check.notNull((Object)interfaceanalysis, (String)"interfaceanalysis");
        return new ImmutableInterfaceAnalysis(interfaceanalysis.getAnnotations(), interfaceanalysis.getExtends(), interfaceanalysis.getImports(), interfaceanalysis.getInterfaceName(), interfaceanalysis.getMethods(), interfaceanalysis.getPackage());
    }

    public ImmutableInterfaceAnalysis(@Nonnull List<Annotation> annotations, @Nonnull List<Interface> extends1, @Nonnull List<Import> imports, @Nonnull String interfaceName, @Nonnull List<Method> methods, @Nonnull Package package1) {
        this.annotations = ImmutableList.copyOf((Collection)((Collection)Check.notNull(annotations, (String)"annotations")));
        this.extends1 = ImmutableList.copyOf((Collection)((Collection)Check.notNull(extends1, (String)"extends1")));
        this.imports = ImmutableList.copyOf((Collection)((Collection)Check.notNull(imports, (String)"imports")));
        this.interfaceName = (String)Check.notNull((Object)interfaceName, (String)"interfaceName");
        this.methods = ImmutableList.copyOf((Collection)((Collection)Check.notNull(methods, (String)"methods")));
        this.package1 = (Package)Check.notNull((Object)package1, (String)"package1");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableInterfaceAnalysis other = (ImmutableInterfaceAnalysis)obj;
        return Objects.equal(this.annotations, other.annotations) && Objects.equal(this.extends1, other.extends1) && Objects.equal(this.imports, other.imports) && Objects.equal((Object)this.interfaceName, (Object)other.interfaceName) && Objects.equal(this.methods, other.methods) && Objects.equal((Object)this.package1, (Object)other.package1);
    }

    @Override
    @Nonnull
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nonnull
    public List<Interface> getExtends() {
        return this.extends1;
    }

    @Override
    @Nonnull
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    @Nonnull
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    @Nonnull
    public List<Method> getMethods() {
        return this.methods;
    }

    @Override
    @Nonnull
    public Package getPackage() {
        return this.package1;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.annotations, this.extends1, this.imports, this.interfaceName, this.methods, this.package1});
    }
}

