/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;

public final class GenericDeclaration {
    public static final GenericDeclaration UNDEFINED = new GenericDeclaration();
    private static final Pattern PATTERN = Pattern.compile("((\\w[\\d\\w])*)(<(\\w+.*)>)?");
    @Nonnull
    private final String _declaration;

    public static GenericDeclaration of(@Nonnull String declaration) {
        return new GenericDeclaration((String)Check.notEmpty((CharSequence)declaration, (String)"declaration"));
    }

    public static GenericDeclaration parseFrom(@Nonnull String typeDeclaration) {
        Check.notNull((Object)typeDeclaration, (String)"typeDeclaration");
        Matcher m = PATTERN.matcher(typeDeclaration);
        return m.matches() && m.group(4) != null ? GenericDeclaration.of(m.group(4)) : UNDEFINED;
    }

    private GenericDeclaration() {
        this._declaration = "";
    }

    private GenericDeclaration(@Nonnull String declaration) {
        this._declaration = (String)Check.notEmpty((CharSequence)declaration, (String)"declaration");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericDeclaration other = (GenericDeclaration)obj;
        return this._declaration.equals(other._declaration);
    }

    public String getDeclaration() {
        return this._declaration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._declaration.hashCode();
        return result;
    }

    public boolean isUndefined() {
        return UNDEFINED.equals(this);
    }

    public String toString() {
        return this._declaration;
    }
}

