/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject.domain;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.Package;
import net.sf.qualitycheck.immutableobject.domain.Type;

public enum CollectionVariant {
    COLLECTION(Collection.class, "new ArrayList%s(%s)", "Lists.newArrayList(%s)", "Collections.unmodifiableList(new ArrayList%s(%s))", "ImmutableCollection.copyOf(%s)"),
    ITERABLE(Iterable.class, "new ArrayList%s(%s)", "Lists.newArrayList(%s)", "Collections.unmodifiableList(new ArrayList%s(%s))", "ImmutableCollection.copyOf(%s)"),
    LIST(List.class, "new ArrayList%s(%s)", "Lists.newArrayList(%s)", "Collections.unmodifiableList(new ArrayList%s(%s))", "ImmutableList.copyOf(%s)"),
    MAP(Map.class, "new HashMap%s(%s)", "Maps.newHashMap(%s)", "Collections.unmodifiableMap(new HashMap%s(%s))", "ImmutableMap.copyOf(%s)"),
    SET(Set.class, "new HashSet%s(%s)", "Sets.newHashSet(%s)", "Collections.unmodifiableSet(new HashSet%s(%s))", "ImmutableSet.copyOf(%s)"),
    SORTEDMAP(SortedMap.class, "new LinkedHashMap%s(%s)", "Maps.newLinkedHashMap(%s)", "Collections.unmodifiableSortedMap(new LinkedHashMap%s(%s))", "ImmutableSortedMap.copyOf(%s)"),
    SORTEDSET(SortedSet.class, "new LinkedHashSet%s(%s)", "Sets.newLinkedHashSet(%)", "Collections.unmodifiableSortedSet(new LinkedHashSet%s(%s))", "ImmutableSortedSet.copyOf(%s)");

    private final String _defaultCopy;
    private final String _defaultImmutable;
    private final String _guavaCopy;
    private final String _guavaImmutable;
    private final Class<?> _type;

    @Nullable
    public static CollectionVariant evaluate(@Nonnull Package pkg, @Nonnull String typeName) {
        Check.notNull((Object)pkg, (String)"pkg");
        Check.notNull((Object)typeName, (String)"typeName");
        CollectionVariant variant = null;
        for (CollectionVariant v : CollectionVariant.values()) {
            if (!v._type.getPackage().getName().equals(pkg.getName()) || !v._type.getSimpleName().equals(typeName)) continue;
            variant = v;
            break;
        }
        return variant;
    }

    @Nullable
    public static CollectionVariant evaluate(@Nonnull Type type) {
        Check.notNull((Object)type, (String)"type");
        return CollectionVariant.evaluate(type.getPackage(), type.getName());
    }

    private CollectionVariant(@Nonnull Class<?> type, @Nonnull String defaultCopy, @Nonnull String guavaCopy, String defaultImmutable, String guavaImmutable) {
        this._type = (Class)Check.notNull(type, (String)"type");
        this._defaultCopy = (String)Check.notNull((Object)defaultCopy, (String)"defaultCopy");
        this._guavaCopy = (String)Check.notNull((Object)guavaCopy, (String)"guavaCopy");
        this._defaultImmutable = (String)Check.notNull((Object)defaultImmutable, (String)"defaultImmutable");
        this._guavaImmutable = (String)Check.notNull((Object)guavaImmutable, (String)"guavaImmutable");
    }

    public String getDefaultCopy() {
        return this._defaultCopy;
    }

    public String getDefaultImmutable() {
        return this._defaultImmutable;
    }

    public String getGuavaCopy() {
        return this._guavaCopy;
    }

    public String getGuavaImmutable() {
        return this._guavaImmutable;
    }
}

