/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.immutableobject;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.immutableobject.domain.ImmutableSettings;
import net.sf.qualitycheck.immutableobject.generator.ImmutableObjectGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    static ImmutableSettings defaultSettings() {
        ImmutableSettings.Builder settings = new ImmutableSettings.Builder();
        settings.jsr305Annotations(true);
        settings.guava(false);
        settings.qualityCheck(true);
        settings.serializable(false);
        settings.builderCopyConstructor(true);
        settings.builderFlatMutators(false);
        settings.builderFluentMutators(true);
        settings.builderName("Builder");
        settings.builderImplementsInterface(false);
        return settings.build();
    }

    public static void main(String[] args) throws Exception {
        Check.notNull((Object)args, (String)"args");
        LOG.info("This tool generates an immutable class from an interface.");
        LOG.info("--");
        LOG.info("--");
        if (args.length == 0) {
            LOG.info("Input a path to an interface, please.");
        }
        LOG.info("--");
        for (String path : args) {
            File file = new File(path);
            String code = Files.toString((File)file, (Charset)Charsets.UTF_8);
            String generated = ImmutableObjectGenerator.generate(code, Main.defaultSettings()).getImplCode();
            LOG.info("\n" + generated);
        }
        LOG.info("--");
        LOG.info("We hope that you saved some time.");
        LOG.info("Your participation in this project is much appreciated!");
    }
}

