/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.exception;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IllegalMissingAnnotationOnMethodException
extends RuntimeException {
    private static final long serialVersionUID = 2122431252273528917L;
    protected static final String DEFAULT_MESSAGE = "Annotation is required on all public methods of the passed class.";
    protected static final String MESSAGE_WITH_METHOD_ANNOTATION_AND_CLASS = "Class '%s' must have annotation '%s' on method '%s'.";
    @Nullable
    private final Class<? extends Annotation> annotation;
    @Nullable
    private final Class<?> clazz;
    @Nullable
    private final Method method;

    private static String format(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation, @Nonnull Method method) {
        if (annotation == null || method == null || clazz == null) {
            throw new IllegalArgumentException("annotation");
        }
        return String.format(MESSAGE_WITH_METHOD_ANNOTATION_AND_CLASS, clazz.getName(), annotation.getName(), method.getName());
    }

    public IllegalMissingAnnotationOnMethodException() {
        super(DEFAULT_MESSAGE);
        this.annotation = null;
        this.clazz = null;
        this.method = null;
    }

    public IllegalMissingAnnotationOnMethodException(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation, @Nonnull Method method) {
        super(IllegalMissingAnnotationOnMethodException.format(clazz, annotation, method));
        this.annotation = annotation;
        this.clazz = clazz;
        this.method = method;
    }

    public IllegalMissingAnnotationOnMethodException(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation, @Nonnull Method method, @Nullable Throwable cause) {
        super(IllegalMissingAnnotationOnMethodException.format(clazz, annotation, method), cause);
        this.annotation = annotation;
        this.clazz = clazz;
        this.method = method;
    }

    public IllegalMissingAnnotationOnMethodException(@Nullable Throwable cause) {
        super(DEFAULT_MESSAGE, cause);
        this.annotation = null;
        this.clazz = null;
        this.method = null;
    }

    public Class<? extends Annotation> getMissingAnnotation() {
        return this.annotation;
    }

    public Class<?> getClassWithoutAnnotation() {
        return this.clazz;
    }

    public Method getMethodWithoutAnnotation() {
        return this.method;
    }
}

