/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullElementsException;
import net.sf.qualitycheck.exception.IllegalPositionIndexException;
import net.sf.qualitycheck.exception.IllegalRangeException;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;

public final class Check {
    private static boolean containsNullElements(@Nullable Object[] array) {
        boolean containsNull = false;
        for (Object o : array) {
            if (o != null) continue;
            containsNull = true;
            break;
        }
        return containsNull;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static void noNullElements(@Nullable Object[] array) {
        Check.notNull(array);
        if (Check.containsNullElements(array)) {
            throw new IllegalNullElementsException();
        }
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static void noNullElements(@Nullable Object[] array, @Nullable String name) {
        Check.notNull(array);
        if (Check.containsNullElements(array)) {
            throw new IllegalNullElementsException(name);
        }
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static String notEmpty(@Nullable String string) {
        Check.notNull(string);
        Check.notEmpty(string, string.isEmpty(), null);
        return string;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static String notEmpty(@Nullable String string, @Nullable String name) {
        Check.notNull(string, name);
        Check.notEmpty(string, string.isEmpty(), name);
        return string;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(@Nullable T collection) {
        Check.notNull(collection);
        Check.notEmpty(collection, collection.isEmpty(), null);
        return collection;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(@Nullable T map) {
        Check.notNull(map);
        Check.notEmpty(map, map.isEmpty(), null);
        return map;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T notEmpty(@Nullable T reference, boolean expression, @Nullable String name) {
        Check.notNull(reference, name);
        if (expression) {
            throw new IllegalEmptyArgumentException(name);
        }
        return reference;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(@Nullable T map, @Nullable String name) {
        Check.notNull(map);
        Check.notEmpty(map, map.isEmpty(), name);
        return map;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(@Nullable T collection, @Nullable String name) {
        Check.notNull(collection, name);
        Check.notEmpty(collection, collection.isEmpty(), name);
        return collection;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(@Nullable T[] array) {
        Check.notNull(array);
        Check.notEmpty(array, array.length == 0, null);
        return array;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(@Nullable T[] array, @Nullable String name) {
        Check.notNull(array);
        Check.notEmpty(array, array.length == 0, null);
        return array;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(@Nullable T reference) {
        if (reference == null) {
            throw new IllegalNullArgumentException();
        }
        return reference;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(@Nullable T reference, @Nullable String name) {
        if (reference == null) {
            throw new IllegalNullArgumentException(name);
        }
        return reference;
    }

    public static int positionIndex(int index, int size) {
        boolean isIndexValid;
        boolean bl = isIndexValid = size >= 0 && index >= 0 && index < size;
        if (!isIndexValid) {
            throw new IllegalPositionIndexException(index, size);
        }
        return index;
    }

    public static void range(@Nonnegative int start, @Nonnegative int end, @Nonnegative int size) {
        boolean inputValuesAreValid;
        boolean rangeIsValid = start <= size && end <= size && start <= end;
        boolean bl = inputValuesAreValid = size >= 0 && start >= 0 && end >= 0;
        if (!rangeIsValid || !inputValuesAreValid) {
            throw new IllegalRangeException(start, end, size);
        }
    }

    public static void stateIsTrue(boolean expression) {
        if (!expression) {
            throw new IllegalStateOfArgumentException();
        }
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static void stateIsTrue(boolean expression, Class<? extends RuntimeException> clazz) {
        Check.notNull(clazz);
        if (!expression) {
            RuntimeException re;
            try {
                re = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            throw re;
        }
    }

    public static void stateIsTrue(boolean expression, @Nonnull String description) {
        if (!expression) {
            throw new IllegalStateOfArgumentException(description);
        }
    }

    public static void stateIsTrue(boolean expression, @Nonnull String descriptionTemplate, Object ... descriptionTemplateArgs) {
        if (!expression) {
            throw new IllegalStateOfArgumentException(descriptionTemplate, descriptionTemplateArgs);
        }
    }

    private Check() {
    }
}

