/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.exception;

import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class IllegalPatternArgumentException
extends RuntimeException {
    private static final long serialVersionUID = -6741481389295600427L;
    protected static final String DEFAULT_MESSAGE = "The passed argument must match against the specified pattern: %s";
    protected static final String MESSAGE_WITH_NAME = "The passed argument '%s' must match against the specified pattern: %s";
    protected static final String NO_PATTERN_PLACEHOLDER = "[not set]";

    private static final String determineMessage(@Nullable String argumentName, @Nullable Pattern pattern) {
        return argumentName != null && !argumentName.isEmpty() ? IllegalPatternArgumentException.format(argumentName, pattern) : IllegalPatternArgumentException.format(pattern);
    }

    private static String format(@Nullable Pattern pattern) {
        return String.format(DEFAULT_MESSAGE, IllegalPatternArgumentException.patternToString(pattern));
    }

    private static String format(@Nullable String argumentName, @Nullable Pattern pattern) {
        String p = IllegalPatternArgumentException.patternToString(pattern);
        return String.format(MESSAGE_WITH_NAME, argumentName, p);
    }

    private static String patternToString(@Nullable Pattern pattern) {
        return pattern != null ? pattern.pattern() + " (flags: " + pattern.flags() + ")" : NO_PATTERN_PLACEHOLDER;
    }

    public IllegalPatternArgumentException(@Nullable Pattern pattern) {
        super(IllegalPatternArgumentException.format(pattern));
    }

    public IllegalPatternArgumentException(@Nullable Pattern pattern, @Nullable Throwable cause) {
        super(IllegalPatternArgumentException.format(pattern), cause);
    }

    public IllegalPatternArgumentException(@Nullable String argumentName, @Nullable Pattern pattern) {
        super(IllegalPatternArgumentException.determineMessage(argumentName, pattern));
    }

    public IllegalPatternArgumentException(@Nullable String argumentName, @Nullable Pattern pattern, @Nullable Throwable cause) {
        super(IllegalPatternArgumentException.determineMessage(argumentName, pattern), cause);
    }
}

