/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.exception;

import javax.annotation.Nullable;

public class IllegalInstanceOfArgumentException
extends RuntimeException {
    private static final long serialVersionUID = -1886931952915327794L;
    protected static final String DEFAULT_MESSAGE = "The passed parameter is a member of an unexpected type.";
    protected static final String MESSAGE_WITH_TYPES = "The passed parameter is a member of an unexpected type (expected type: %s, actual: %s).";
    protected static final String MESSAGE_WITH_NAME_AND_TYPES = "The passed parameter '%s' is a member of an unexpected type (expected type: %s, actual: %s).";
    protected static final String NO_TYPE_PLACEHOLDER = "(not set)";

    private static final String determineMessage(@Nullable String parameterName, @Nullable Class<?> expectedType, @Nullable Class<?> actualType) {
        return parameterName != null && !parameterName.isEmpty() ? IllegalInstanceOfArgumentException.format(parameterName, expectedType, actualType) : IllegalInstanceOfArgumentException.format(expectedType, actualType);
    }

    private static String format(@Nullable Class<?> expectedType, @Nullable Class<?> actualType) {
        String expected = expectedType != null ? expectedType.getName() : NO_TYPE_PLACEHOLDER;
        String actual = actualType != null ? actualType.getName() : NO_TYPE_PLACEHOLDER;
        return String.format(MESSAGE_WITH_TYPES, expected, actual);
    }

    private static String format(@Nullable String parameterName, @Nullable Class<?> expectedType, @Nullable Class<?> actualType) {
        String expected = expectedType != null ? expectedType.getName() : NO_TYPE_PLACEHOLDER;
        String actual = actualType != null ? actualType.getName() : NO_TYPE_PLACEHOLDER;
        return String.format(MESSAGE_WITH_NAME_AND_TYPES, parameterName, expected, actual);
    }

    public IllegalInstanceOfArgumentException() {
        super(DEFAULT_MESSAGE);
    }

    public IllegalInstanceOfArgumentException(@Nullable String parameterName, @Nullable Class<?> expectedType, @Nullable Class<?> actualType) {
        super(IllegalInstanceOfArgumentException.determineMessage(parameterName, expectedType, actualType));
    }

    public IllegalInstanceOfArgumentException(@Nullable Throwable cause) {
        super(DEFAULT_MESSAGE, cause);
    }
}

