/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalInstanceOfArgumentException;
import net.sf.qualitycheck.exception.IllegalNaNArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullElementsException;
import net.sf.qualitycheck.exception.IllegalNumberArgumentException;
import net.sf.qualitycheck.exception.IllegalNumericArgumentException;
import net.sf.qualitycheck.exception.IllegalPatternArgumentException;
import net.sf.qualitycheck.exception.IllegalPositionIndexException;
import net.sf.qualitycheck.exception.IllegalRangeException;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;

public final class Check {
    private static String EMPTY_ARGUMENT_NAME = "";

    private static boolean containsNullElements(@Nonnull Object[] array) {
        boolean containsNull = false;
        for (Object o : array) {
            if (o != null) continue;
            containsNull = true;
            break;
        }
        return containsNull;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static void instanceOf(@Nonnull Class<?> type, @Nullable Object obj) {
        Check.instanceOf(type, obj, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static void instanceOf(@Nonnull Class<?> type, @Nullable Object obj, @Nullable String name) {
        Check.notNull(type);
        Check.notNull(obj);
        if (!type.isInstance(obj)) {
            throw new IllegalInstanceOfArgumentException(name, type, obj.getClass());
        }
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static int isNumber(@Nullable String value) {
        int number;
        Check.notNull(value);
        try {
            number = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalNumberArgumentException(nfe);
        }
        return number;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static int isNumber(@Nullable String value, @Nullable String name) {
        int number;
        Check.notNull(value);
        try {
            number = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalNumberArgumentException(name, nfe);
        }
        return number;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T extends CharSequence> T isNumeric(@Nullable T value) {
        return Check.isNumeric(value, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T extends CharSequence> T isNumeric(@Nullable T value, @Nullable String name) {
        Check.notNull(value);
        if (!Check.matches(NumericRegularExpressionHolder.getPattern(), value)) {
            throw new IllegalNumericArgumentException(name);
        }
        return value;
    }

    private static boolean matches(@Nonnull Pattern pattern, @Nonnull CharSequence chars) {
        return pattern.matcher(chars).matches();
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T extends CharSequence> T matchesPattern(@Nonnull Pattern pattern, @Nullable T chars) {
        return Check.matchesPattern(pattern, chars, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T extends CharSequence> T matchesPattern(@Nonnull Pattern pattern, @Nullable T chars, @Nullable String name) {
        Check.notNull(pattern);
        Check.notNull(chars);
        if (!Check.matches(pattern, chars)) {
            throw new IllegalPatternArgumentException(name, pattern);
        }
        return chars;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T extends Iterable<?>> T noNullElements(@Nullable T iterable) {
        return Check.noNullElements(iterable, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T extends Iterable<?>> T noNullElements(@Nullable T iterable, String name) {
        Check.notNull(iterable);
        for (Object element : iterable) {
            if (element != null) continue;
            throw new IllegalNullElementsException(name);
        }
        return iterable;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T> T[] noNullElements(@Nullable T[] array) {
        return Check.noNullElements(array, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static <T> T[] noNullElements(@Nullable T[] array, @Nullable String name) {
        Check.notNull(array);
        if (Check.containsNullElements(array)) {
            throw new IllegalNullElementsException(name);
        }
        return array;
    }

    @ArgumentsChecked(value={IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean expression) {
        Check.notEmpty(expression, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked(value={IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean expression, @Nullable String name) {
        if (expression) {
            throw new IllegalEmptyArgumentException(name);
        }
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> T notEmpty(@Nullable T chars) {
        Check.notNull(chars);
        Check.notEmpty(chars, chars.length() == 0, EMPTY_ARGUMENT_NAME);
        return chars;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(@Nullable T collection) {
        Check.notNull(collection);
        Check.notEmpty(collection, collection.isEmpty(), EMPTY_ARGUMENT_NAME);
        return collection;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(@Nullable T map) {
        Check.notNull(map);
        Check.notEmpty(map, map.isEmpty(), EMPTY_ARGUMENT_NAME);
        return map;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T notEmpty(@Nullable T reference, boolean expression, @Nullable String name) {
        Check.notNull(reference, name);
        if (expression) {
            throw new IllegalEmptyArgumentException(name);
        }
        return reference;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> T notEmpty(@Nullable T chars, @Nullable String name) {
        Check.notNull(chars, name);
        Check.notEmpty(chars, chars.length() == 0, name);
        return chars;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(@Nullable T map, @Nullable String name) {
        Check.notNull(map);
        Check.notEmpty(map, map.isEmpty(), name);
        return map;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(@Nullable T collection, @Nullable String name) {
        Check.notNull(collection, name);
        Check.notEmpty(collection, collection.isEmpty(), name);
        return collection;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(@Nullable T[] array) {
        Check.notNull(array);
        Check.notEmpty(array, array.length == 0, EMPTY_ARGUMENT_NAME);
        return array;
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(@Nullable T[] array, @Nullable String name) {
        Check.notNull(array);
        Check.notEmpty(array, array.length == 0, EMPTY_ARGUMENT_NAME);
        return array;
    }

    public static double notNaN(double value) {
        return Check.notNaN(value, EMPTY_ARGUMENT_NAME);
    }

    public static double notNaN(double value, @Nullable String name) {
        if (value != value) {
            throw new IllegalNaNArgumentException(name);
        }
        return value;
    }

    public static float notNaN(float value) {
        return Check.notNaN(value, EMPTY_ARGUMENT_NAME);
    }

    public static float notNaN(float value, @Nullable String name) {
        if (value != value) {
            throw new IllegalNaNArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(@Nullable T reference) {
        if (reference == null) {
            throw new IllegalNullArgumentException();
        }
        return reference;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(@Nullable T reference, @Nullable String name) {
        if (reference == null) {
            throw new IllegalNullArgumentException(name);
        }
        return reference;
    }

    public static int positionIndex(int index, int size) {
        boolean isIndexValid;
        boolean bl = isIndexValid = size >= 0 && index >= 0 && index < size;
        if (!isIndexValid) {
            throw new IllegalPositionIndexException(index, size);
        }
        return index;
    }

    public static void range(@Nonnegative int start, @Nonnegative int end, @Nonnegative int size) {
        boolean inputValuesAreValid;
        boolean rangeIsValid = start <= size && end <= size && start <= end;
        boolean bl = inputValuesAreValid = size >= 0 && start >= 0 && end >= 0;
        if (!rangeIsValid || !inputValuesAreValid) {
            throw new IllegalRangeException(start, end, size);
        }
    }

    public static void stateIsTrue(boolean expression) {
        if (!expression) {
            throw new IllegalStateOfArgumentException();
        }
    }

    @ArgumentsChecked(value={IllegalNullArgumentException.class})
    public static void stateIsTrue(boolean expression, Class<? extends RuntimeException> clazz) {
        Check.notNull(clazz);
        if (!expression) {
            RuntimeException re;
            try {
                re = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            throw re;
        }
    }

    public static void stateIsTrue(boolean expression, @Nonnull String description) {
        if (!expression) {
            throw new IllegalStateOfArgumentException(description);
        }
    }

    public static void stateIsTrue(boolean expression, @Nonnull String descriptionTemplate, Object ... descriptionTemplateArgs) {
        if (!expression) {
            throw new IllegalStateOfArgumentException(descriptionTemplate, descriptionTemplateArgs);
        }
    }

    private Check() {
    }

    private static final class NumericRegularExpressionHolder {
        private static Pattern NUMERIC_REGEX = Pattern.compile("[0-9]+");

        private NumericRegularExpressionHolder() {
        }

        @Nonnull
        public static Pattern getPattern() {
            return NUMERIC_REGEX;
        }
    }
}

