/*
 * Decompiled with CFR 0.152.
 */
package phat.server.speaker;

import com.jme3.app.Application;
import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioNode;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.BufferUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import phat.server.ServerAppState;
import phat.server.TCPSensorServer;
import phat.server.commands.PHATServerCommand;
import phat.util.SpatialFactory;
import phat.util.controls.RemoveSpatialTimerControl;

public class TCPAudioSpeakerServer
implements TCPSensorServer {
    protected ServerSocket serverSocket;
    protected AudioInputStream audioInputStream;
    private String ip;
    private int port;
    private Thread serverThread;
    private Socket socket;
    private boolean endServer = false;
    private Node device;
    private AudioNode audioNode;
    private AudioBuffer audioBuffer;
    private static final float FRECUENCY = 16000.0f;
    private static final float BITS_PER_SAMPLE = 16.0f;
    private final ServerAppState serverAppState;
    byte[] buffer;
    Node sphereNode;

    private ByteBuffer readToBuffer(InputStream inputStream) throws IOException, ClassNotFoundException, UnsupportedAudioFileException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.out.println("Available = " + this.audioInputStream.available());
        boolean lastLenght = false;
        int bufferSize = 1024;
        byte[] buf = new byte[bufferSize];
        while ((read = this.audioInputStream.read(buf, 0, bufferSize)) != -1) {
            baos.write(buf, 0, read);
        }
        baos.flush();
        byte[] audioData = baos.toByteArray();
        System.out.println("total received data = " + audioData.length);
        ByteBuffer data = BufferUtils.createByteBuffer((int)audioData.length);
        data.put(audioData, 0, audioData.length).flip();
        baos.close();
        return data;
    }

    public TCPAudioSpeakerServer(ServerAppState serverAppState, InetAddress ip, int port, Node device) throws IOException {
        this.serverAppState = serverAppState;
        this.ip = ip.getHostAddress();
        this.port = port;
        this.device = device;
        this.serverSocket = new ServerSocket(port, 0, ip);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TCPAudioSpeakerServer.this.endServer) {
                        try {
                            Socket socket = TCPAudioSpeakerServer.this.serverSocket.accept();
                            System.out.println("Nuevo Cliente: " + socket);
                            TCPAudioSpeakerServer.this.upClient(socket);
                        }
                        catch (SocketException ex) {
                            if (TCPAudioSpeakerServer.this.endServer) continue;
                            Logger.getLogger(TCPAudioSpeakerServer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TCPAudioSpeakerServer.class.getName()).log(Level.SEVERE, null, ex);
                    TCPAudioSpeakerServer.this.socket = null;
                    TCPAudioSpeakerServer.this.audioInputStream = null;
                }
            }
        });
        this.serverThread.start();
    }

    private synchronized void upClient(Socket socket) {
        this.socket = socket;
        try {
            BufferedInputStream bis = new BufferedInputStream(socket.getInputStream());
            System.out.println("BufferedInputStream.avaliable = " + bis.available());
            this.audioInputStream = AudioSystem.getAudioInputStream(bis);
            if (this.audioNode == null) {
                this.audioBuffer = new AudioBuffer();
                this.audioNode = new AudioNode((AudioData)this.audioBuffer, new AudioKey("Speaker-" + this.device.getName(), true, true));
                this.audioNode.setName("Speaker-" + this.device.getName());
            } else {
                this.audioBuffer.resetObject();
            }
            this.audioBuffer.setupFormat(1, 16, 16000);
            this.audioBuffer.updateData(this.readToBuffer(this.audioInputStream));
            this.serverAppState.runCommand(new AddSpatialCommand(this.audioNode, this.device));
        }
        catch (IOException ex) {
            Logger.getLogger(TCPAudioSpeakerServer.class.getName()).log(Level.SEVERE, null, ex);
            this.audioInputStream = null;
            this.socket = null;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TCPAudioSpeakerServer.class.getName()).log(Level.SEVERE, null, ex);
            this.audioInputStream = null;
            this.socket = null;
        }
        catch (UnsupportedAudioFileException ex) {
            Logger.getLogger(TCPAudioSpeakerServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            System.out.println("Close objectInputStream and socket!");
            if (this.audioInputStream != null) {
                this.audioInputStream.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TCPAudioSpeakerServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void stop() {
        try {
            this.endServer = true;
            this.serverSocket.close();
            if (this.audioInputStream != null) {
                this.audioInputStream.close();
                this.audioInputStream = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, null, e1);
        }
    }

    class AddSpatialCommand
    extends PHATServerCommand {
        private final AudioNode audioNode;
        private final Node root;

        public AddSpatialCommand(AudioNode audioNode, Node root) {
            super(null);
            this.audioNode = audioNode;
            this.root = root;
        }

        public void runCommand(Application app) {
            if (this.audioNode.getParent() == null) {
                System.out.println("attach " + this.audioNode.getName() + " to " + this.root);
                this.root.attachChild((Spatial)this.audioNode);
            }
            if (TCPAudioSpeakerServer.this.sphereNode == null) {
                TCPAudioSpeakerServer.this.sphereNode = new Node();
                Geometry geo = SpatialFactory.createSphere((float)0.2f, (ColorRGBA)ColorRGBA.Blue.clone().set(ColorRGBA.Blue.r, ColorRGBA.Blue.r, ColorRGBA.Blue.r, 0.5f), (boolean)true);
                TCPAudioSpeakerServer.this.sphereNode.attachChild((Spatial)geo);
                TCPAudioSpeakerServer.this.sphereNode.addControl((Control)new RemoveSpatialTimerControl(2.0f));
            }
            RemoveSpatialTimerControl rstc = (RemoveSpatialTimerControl)TCPAudioSpeakerServer.this.sphereNode.getControl(RemoveSpatialTimerControl.class);
            rstc.reset();
            this.root.attachChild((Spatial)TCPAudioSpeakerServer.this.sphereNode);
            System.out.println("Play audio!!");
            this.audioNode.setVolume(0.5f);
            this.audioNode.play();
        }

        public void interruptCommand(Application app) {
        }
    }
}

