/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import java.util.logging.Logger;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.body.BodiesAppState;
import phat.body.commands.RandomWalkingCommand;
import phat.body.commands.SetBodyInCoordenatesCommand;
import phat.body.commands.SetCameraToBodyCommand;
import phat.body.commands.SetPCListenerToBodyCommand;
import phat.body.commands.SetSpeedDisplacemenetCommand;
import phat.body.commands.SetStoopedBodyCommand;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceOnPartOfBodyCommand;
import phat.server.ServerAppState;
import phat.server.commands.ActivateSpeakerServerCommand;
import phat.structures.houses.TestHouse;
import phat.util.Debug;
import phat.util.SpatialFactory;
import phat.world.WorldAppState;

public class SpeakerTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    BodiesAppState bodiesAppState;
    ServerAppState serverAppState;
    DevicesAppState devicesAppState;
    WorldAppState worldAppState;

    public static void main(String[] args) {
        SpeakerTest test = new SpeakerTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        AppSettings settings = new AppSettings(true);
        settings.setTitle("PHAT");
        settings.setWidth(640);
        settings.setHeight(480);
        phat.setSettings(settings);
        phat.start();
    }

    public void init(SimpleApplication app) {
        SpatialFactory.init((AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(0.2599395f, 2.7232018f, 3.373138f));
        app.getCamera().setRotation(new Quaternion(-0.0035931943f, 0.9672268f, -0.25351822f, -0.013704466f));
        this.worldAppState = new WorldAppState();
        this.worldAppState.setLandType(WorldAppState.LandType.Grass);
        app.getStateManager().attach((AppState)this.worldAppState);
        this.worldAppState.setCalendar(2013, 1, 1, 12, 0, 0);
        Debug.enableDebugGrid((float)10.0f, (AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        this.bodiesAppState = new BodiesAppState();
        stateManager.attach((AppState)this.bodiesAppState);
        this.bodiesAppState.createBody(BodiesAppState.BodyType.ElderLP, "Patient");
        this.bodiesAppState.runCommand((PHATCommand)new SetBodyInCoordenatesCommand("Patient", Vector3f.ZERO));
        this.bodiesAppState.runCommand((PHATCommand)new RandomWalkingCommand("Patient", true));
        this.bodiesAppState.runCommand((PHATCommand)new SetPCListenerToBodyCommand("Patient"));
        this.bodiesAppState.runCommand((PHATCommand)new SetSpeedDisplacemenetCommand("Patient", 0.5f));
        this.bodiesAppState.runCommand((PHATCommand)new SetStoopedBodyCommand("Patient", Boolean.valueOf(true)));
        SetCameraToBodyCommand camCommand = new SetCameraToBodyCommand("Patient");
        camCommand.setDistance(3.0f);
        camCommand.setFront(true);
        this.bodiesAppState.runCommand((PHATCommand)camCommand);
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone1"));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnPartOfBodyCommand("Patient", "Smartphone1", SetDeviceOnPartOfBodyCommand.PartOfBody.Chest));
        this.serverAppState = new ServerAppState();
        stateManager.attach((AppState)this.serverAppState);
        this.serverAppState.runCommand(new ActivateSpeakerServerCommand("Smartphone1", "Speaker"));
    }
}

