/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import java.util.logging.Logger;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.body.BodiesAppState;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceInCoordenatesCommand;
import phat.server.ServerAppState;
import phat.server.commands.DisplayAVDScreenCommand;
import phat.server.commands.SetAndroidEmulatorCommand;
import phat.structures.houses.HouseAppState;
import phat.structures.houses.TestHouse;
import phat.util.SpatialFactory;
import phat.world.WorldAppState;

public class ScreenAVDTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    ServerAppState serverAppState;
    DevicesAppState devicesAppState;
    WorldAppState worldAppState;
    HouseAppState houseAppState;
    BodiesAppState bodiesAppState;

    public static void main(String[] args) {
        ScreenAVDTest test = new ScreenAVDTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        AppSettings settings = new AppSettings(true);
        settings.setTitle("PHAT");
        settings.setWidth(640);
        settings.setHeight(480);
        phat.setSettings(settings);
        phat.start();
    }

    public void init(SimpleApplication app) {
        SpatialFactory.init((AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(3.619537f, 2.4257905f, 6.62355f));
        app.getCamera().setRotation(new Quaternion(0.26168963f, -0.47725555f, 0.15136504f, 0.8251268f));
        BulletAppState bulletAppState = new BulletAppState();
        bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        stateManager.attach((AppState)bulletAppState);
        bulletAppState.getPhysicsSpace().setAccuracy(0.016666668f);
        this.worldAppState = new WorldAppState();
        this.worldAppState.setLandType(WorldAppState.LandType.Grass);
        app.getStateManager().attach((AppState)this.worldAppState);
        this.worldAppState.setCalendar(2013, 1, 1, 12, 0, 0);
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone1"));
        SetDeviceInCoordenatesCommand command = new SetDeviceInCoordenatesCommand("Smartphone1", new Vector3f(2.05f, 0.9f, 7.95722f));
        command.setScale(1.0f);
        command.setRotation(new Quaternion().fromAngleAxis(1.5707964f, Vector3f.UNIT_X));
        this.devicesAppState.runCommand((PHATDeviceCommand)command);
        this.serverAppState = new ServerAppState();
        stateManager.attach((AppState)this.serverAppState);
        this.serverAppState.runCommand(new SetAndroidEmulatorCommand("Smartphone1", "Smartphone1", "emulator-5554"));
        DisplayAVDScreenCommand displayCommand = new DisplayAVDScreenCommand("Smartphone1", "Smartphone1");
        displayCommand.setFrecuency(0.5f);
        this.serverAppState.runCommand(displayCommand);
    }
}

