/*
 * Decompiled with CFR 0.152.
 */
package phat.server.commands.tests;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import phat.app.PHATApplication;
import phat.app.PHATInitAppListener;
import phat.body.BodiesAppState;
import phat.body.commands.RandomWalkingCommand;
import phat.body.commands.SetBodyInCoordenatesCommand;
import phat.body.commands.SetCameraToBodyCommand;
import phat.body.commands.SetSpeedDisplacemenetCommand;
import phat.body.commands.SetStoopedBodyCommand;
import phat.commands.PHATCommand;
import phat.devices.DevicesAppState;
import phat.devices.commands.CreateAccelerometerSensorCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceOnPartOfBodyCommand;
import phat.mobile.servicemanager.client.RemoteSocketClient;
import phat.mobile.servicemanager.services.Service;
import phat.sensors.SensorData;
import phat.sensors.SensorListener;
import phat.sensors.accelerometer.AccelerationData;
import phat.sensors.accelerometer.AccelerometerControl;
import phat.sensors.accelerometer.XYAccelerationsChart;
import phat.server.PHATServerManager;
import phat.server.ServerAppState;
import phat.server.commands.ActivateAccelerometerServerCommand;
import phat.structures.houses.TestHouse;
import phat.util.Debug;
import phat.util.SpatialFactory;
import phat.world.WorldAppState;
import sim.android.hardware.service.SimSensorEvent;

public class RemoteAccelerometerParkinsonTest
implements PHATInitAppListener {
    private static final Logger logger = Logger.getLogger(TestHouse.class.getName());
    BodiesAppState bodiesAppState;
    ServerAppState serverAppState;
    DevicesAppState devicesAppState;
    WorldAppState worldAppState;

    public static void main(String[] args) {
        RemoteAccelerometerParkinsonTest test = new RemoteAccelerometerParkinsonTest();
        PHATApplication phat = new PHATApplication((PHATInitAppListener)test);
        phat.setDisplayFps(true);
        phat.setDisplayStatView(false);
        AppSettings settings = new AppSettings(true);
        settings.setTitle("PHAT");
        settings.setWidth(640);
        settings.setHeight(480);
        phat.setSettings(settings);
        phat.start();
    }

    public void init(SimpleApplication app) {
        SpatialFactory.init((AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        AppStateManager stateManager = app.getStateManager();
        app.getFlyByCamera().setMoveSpeed(10.0f);
        app.getCamera().setLocation(new Vector3f(0.2599395f, 2.7232018f, 3.373138f));
        app.getCamera().setRotation(new Quaternion(-0.0035931943f, 0.9672268f, -0.25351822f, -0.013704466f));
        this.worldAppState = new WorldAppState();
        this.worldAppState.setLandType(WorldAppState.LandType.Grass);
        app.getStateManager().attach((AppState)this.worldAppState);
        this.worldAppState.setCalendar(2013, 1, 1, 12, 0, 0);
        Debug.enableDebugGrid((float)10.0f, (AssetManager)app.getAssetManager(), (Node)app.getRootNode());
        this.bodiesAppState = new BodiesAppState();
        stateManager.attach((AppState)this.bodiesAppState);
        this.bodiesAppState.createBody(BodiesAppState.BodyType.ElderLP, "Patient");
        this.bodiesAppState.runCommand((PHATCommand)new SetBodyInCoordenatesCommand("Patient", Vector3f.ZERO));
        this.bodiesAppState.runCommand((PHATCommand)new RandomWalkingCommand("Patient", true));
        this.bodiesAppState.runCommand((PHATCommand)new SetSpeedDisplacemenetCommand("Patient", 0.5f));
        this.bodiesAppState.runCommand((PHATCommand)new SetStoopedBodyCommand("Patient", Boolean.valueOf(true)));
        SetCameraToBodyCommand camCommand = new SetCameraToBodyCommand("Patient");
        camCommand.setDistance(3.0f);
        camCommand.setFront(true);
        this.bodiesAppState.runCommand((PHATCommand)camCommand);
        this.devicesAppState = new DevicesAppState();
        stateManager.attach((AppState)this.devicesAppState);
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateAccelerometerSensorCommand("sensor1"));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnPartOfBodyCommand("Patient", "sensor1", SetDeviceOnPartOfBodyCommand.PartOfBody.Chest));
        this.devicesAppState.runCommand((PHATDeviceCommand)new CreateAccelerometerSensorCommand("sensor2"));
        this.devicesAppState.runCommand((PHATDeviceCommand)new SetDeviceOnPartOfBodyCommand("Patient", "sensor2", SetDeviceOnPartOfBodyCommand.PartOfBody.LeftHand));
        this.serverAppState = new ServerAppState();
        stateManager.attach((AppState)this.serverAppState);
        this.serverAppState.runCommand(new ActivateAccelerometerServerCommand("PatientBodyAccel", "sensor1"));
        this.serverAppState.runCommand(new ActivateAccelerometerServerCommand("PatientBodyAccel", "sensor2"));
        RemoteAccelerometerParkinsonTest.launchRemoteXYChart("Chest Remote", PHATServerManager.getAddress(), "sensor1");
        RemoteAccelerometerParkinsonTest.launchRemoteXYChart("RightHand Remote", PHATServerManager.getAddress(), "sensor2");
        stateManager.attach((AppState)new AbstractAppState(){
            PHATApplication app;
            boolean standUp = false;
            boolean washingHands = false;
            boolean havingShower = false;
            float cont = 0.0f;
            boolean fall = false;
            float timeToFall = 10.0f;
            boolean init = false;

            public void initialize(AppStateManager asm, Application aplctn) {
                this.app = (PHATApplication)aplctn;
            }

            public void update(float f) {
                if (!this.init) {
                    AccelerometerControl ac = (AccelerometerControl)RemoteAccelerometerParkinsonTest.this.devicesAppState.getDevice("sensor1").getControl(AccelerometerControl.class);
                    ac.setMode(AccelerometerControl.AMode.ACCELEROMETER_MODE);
                    XYAccelerationsChart chart = new XYAccelerationsChart("Chart - Acc.", "Local accelerations", "m/s2", "x,y,z");
                    ac.add((SensorListener)chart);
                    chart.showWindow();
                    this.init = true;
                }
            }
        });
    }

    public static void launchRemoteXYChart(final String title, final InetAddress host, final String sensor) {
        new Thread(){

            @Override
            public void run() {
                try {
                    final XYAccelerationsChart chart = new XYAccelerationsChart(title, "Remote " + sensor + ":" + title + " accelerations", "m/s2", "x,y,z");
                    chart.showWindow();
                    Service sensorService = null;
                    for (int k = 0; k < 5 && sensorService == null; ++k) {
                        sensorService = RemoteSocketClient.getService((InetAddress)host, (int)PHATServerManager.getPort(), (String)sensor);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    Socket s = RemoteSocketClient.createSocket((InetAddress)PHATServerManager.getAddress(), (int)RemoteSocketClient.getService((InetAddress)PHATServerManager.getAddress(), (int)PHATServerManager.getPort(), (String)sensor).getPort(), (int)10, (long)1000L);
                    if (s == null) {
                        throw new RuntimeException("Could not connect to host " + PHATServerManager.getAddress() + " at port " + PHATServerManager.getPort());
                    }
                    BufferedReader is = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String objRead = null;
                    Long lastRead = new Date().getTime();
                    do {
                        SimSensorEvent sse;
                        objRead = is.readLine();
                        final long interval = new Date().getTime() - lastRead;
                        lastRead = new Date().getTime();
                        if (objRead == null || objRead.isEmpty() || (sse = SimSensorEvent.fromString((String)objRead)) == null) continue;
                        final float x = sse.getValues()[0];
                        final float y = sse.getValues()[1];
                        final float z = sse.getValues()[2];
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AccelerationData ad = new AccelerationData((float)interval, x, y, z);
                                chart.update(null, (SensorData)ad);
                                chart.repaint();
                            }
                        });
                    } while (objRead != null);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

